
package tecgraf.javautils.gui.wizard;

/**
 * Representa um ouvinte interessado em ouvir eventos em um wizard (assistente).
 *
 * @author Tecgraf/PUC-Rio
 */
public interface IWizardListener {
  /**
   *  chamado quando o wizard  cancelado.
   *
   * @param step O passo onde o wizard foi cancelado.
   */
  void wasCancelled(Step step);

  /**
   *  chamado quando o wizard  fechado.
   *
   * @param step O passo onde o wizard foi fechado.
   */
  void wasClosed(Step step);

  /**
   *  chamado quando o wizard  confirmado.
   *
   * @param step O passo onde o wizard foi confirmado.
   * @param result O resultado da confirmao do passo.
   */
  void wasConfirmed(Step step, Object result);

  /**
   *  chamado quando o wizard vai para o prximo passo.
   *
   * @param currentStep O passo atual.
   * @param history O histrico.
   */
  void wasGoneNext(Step currentStep, History history);

  /**
   *  chamado quando o wizard vai para o passo anterior.
   *
   * @param currentStep O passo atual.
   * @param history O histrico.
   */
  void wasGonePrevious(Step currentStep, History history);

  /**
   *  chamado quando acontece uma exceo no wizard.
   *
   * @param step O passo onde a exceo ocorreu.
   * @param exception A exceo que ocorreu.
   */
  void wasHappenedException(Step step, WizardException exception);
}
