/*
 * $Id: DefaultNode.java 65761 2007-07-25 18:16:50Z clinio $
 */
package tecgraf.javautils.gui.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.Icon;

/**
 * N-padro.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DefaultNode implements Node {

  /**
   * Os filhos.
   */
  private List<DefaultNode> children;

  /**
   * O modo de filtragem.
   */
  private FiltrageMode filtrageMode;

  /**
   * O rtulo.
   */
  private String label;

  /**
   * O pai.
   */
  private DefaultNode parent;

  /**
   * Cria o n sem dica como modo de filtragem padro ({@link Node.FiltrageMode#EVALUATE}).
   * 
   * @param label O rtulo (Aceita {@code null}).
   */
  public DefaultNode(String label) {
    this(label, FiltrageMode.EVALUATE);
  }

  /**
   * Cria o n sem dica.
   * 
   * @param label O rtulo (No aceita {@code null}).
   * @param filtrageMode O modo de filtragem (No aceita {@code null}).
   */
  public DefaultNode(String label, FiltrageMode filtrageMode) {
    children = new ArrayList<DefaultNode>();
    this.label = label;
    setFiltrageMode(filtrageMode);
  }

  /**
   * Adiciona {@code child} a lista de filhos deste n e coloca este n como pai
   * de {@code child}.
   * 
   * @param child O filho (No aceita {@code null}).
   */
  public final void addChild(DefaultNode child) {
    if (child == null) {
      throw new IllegalArgumentException("O parmetro child est nulo.");
    }
    children.add(child);
    child.parent = this;
  }

  /**
   * {@inheritDoc}
   */
  public final List<DefaultNode> getChildren() {
    return Collections.unmodifiableList(children);
  }

  /**
   * {@inheritDoc}
   */
  public final FiltrageMode getFiltrageMode() {
    return filtrageMode;
  }

  /**
   * {@inheritDoc}
   */
  public Icon getIcon() {
    return null;
  }

  /**
   * {@inheritDoc}
   */
  public final String getLabel() {
    return label;
  }

  /**
   * {@inheritDoc}
   */
  public final DefaultNode getParent() {
    return parent;
  }

  /**
   * {@inheritDoc}
   */
  public final void setFiltrageMode(FiltrageMode filtrageMode) {
    if (filtrageMode == null) {
      throw new IllegalArgumentException("O parmetro filtrageMode est nulo.");
    }
    this.filtrageMode = filtrageMode;
  }
}