package tecgraf.javautils.gui.crud.gui.table;

import javax.swing.table.AbstractTableModel;

import tecgraf.javautils.gui.crud.IRegistrationDescriptor;

/**
 * Modelo da tabela.
 * 
 * @author Tecgraf
 * @param <M> tipo do objeto do modelo.
 * @param <I> tipo do objeto da interface.
 */
class RegistrationTableModel<M, I> extends AbstractTableModel {

  /**
   * Descritor
   */
  final private IRegistrationDescriptor<M, I> descriptor;

  /**
   * {@inheritDoc}
   */
  @Override
  final public int getColumnCount() {
    return descriptor.getNumColumns();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public int getRowCount() {
    return descriptor.getNumObjects();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public M getValueAt(final int row, final int col) {
    return descriptor.getObject(row);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public String getColumnName(final int col) {
    final String columnName = descriptor.getColumnName(col);
    return columnName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public Class<?> getColumnClass(final int col) {
    return descriptor.getColumnClass();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public boolean isCellEditable(final int row, final int col) {
    return false;
  }

  /**
   * Construtor.
   * 
   * @param descriptor descritor
   */
  public RegistrationTableModel(final IRegistrationDescriptor<M, I> descriptor) {
    this.descriptor = descriptor;
  }
}
