package tecgraf.javautils.gui.searchpanel;

/**
 *  uma viso que permite uma consulta rpida pelo nome.
 * 
 * @author Tecgraf
 */
public interface AbstractSearchView {

  /**
   * Seleciona a primeira ocorrncia de nome que contenha o valor da
   * <code>searchString</code>.<br>
   * Caso seja passado true em <code>matchExactly</code>, a procura ser pelo
   * valor exato.
   * 
   * @param searchString string de busca
   * @param matchExactly caso verdadeiro, procura apenas pelo valor exato
   * @return verdadeiro caso a seleo tenha sido feita com sucesso, falso se o
   *         valor no foi encontrado.
   * 
   */
  public abstract boolean selectSearch(String searchString, boolean matchExactly);

  /**
   * Seleciona a prxima ocorrncia (a partir da seleo corrente) com nome que
   * contenha o valor da <code>searchString</code>.
   * 
   * @param searchString string de busca
   * @return verdadeiro caso a seleo tenha sido feita com sucesso, falso se o
   *         valor no foi encontrado.
   * 
   */
  public abstract boolean selectSearchNext(String searchString);
}
