package tecgraf.javautils.gui.table;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

/**
 * Exemplo de uso da classe {@link RowHeaderTablePane}.
 * 
 * @author Tecgraf
 */
public class RowHeaderTablePaneSample {
  /** Linhas da tabela */
  private static String[] rows = { "A", "B", "C", "D", "E", "F", "G", "H", "I",
      "J" };

  /**
   * Cria uma janela para exibir o componente.
   * 
   * @param args no usado.
   */
  public static void main(String[] args) {
    SwingUtilities.invokeLater(new Runnable() {

      @Override
      public void run() {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.add(createPane());
        f.setSize(400, 400);
        f.setVisible(true);
      }
    });

  }

  /**
   * @return o componente de painel com base em uma tabela.
   */
  protected static Component createPane() {
    List<? extends Object> rowNames = Arrays.asList(rows);
    String rowHeaderTitle = "Canto";
    RowHeaderTablePane tablePane =
      new RowHeaderTablePane(createTable(), rowNames, rowHeaderTitle);
    return tablePane;
  }

  /**
   * @return tabela simples.
   */
  private static JTable createTable() {
    JTable table = new JTable(new DefaultTableModel(rows.length, 10));
    return table;
  }
}
