
package tecgraf.javautils.gui.wizard;

import java.text.MessageFormat;

/**
 * Representa uma exceo do wizard (assistente).
 *
 * @author Tecgraf/PUC-Rio
 */
public class WizardException extends Exception {
  /**
   * Cria uma exceo com a mensagem recebida.
   *
   * @param message A mensagem da exceo.
   */
  public WizardException(String message) {
    super(message);
  }

  /**
   * Cria uma exceo com o padro recebido e com os argumentos que sero
   * utilizados para formatar o padro.
   *
   * @param messagePattern Um padro para a criao da mensagem.
   * @param args Os argumentos usados para formatar o padro.
   *
   * @see MessageFormat
   */
  public WizardException(String messagePattern, Object[] args) {
    super(MessageFormat.format(messagePattern, args));
  }

  /**
   * Cria uma exceo com o padro recebido, com os argumentos que sero
   * utilizados para formatar o padro e com a causa da exceo.
   *
   * @param messagePattern Um padro para a criao da mensagem.
   * @param cause A causa da exceo.
   * @param args Os argumentos usados para formatar o padro.
   *
   * @see MessageFormat
   */
  public WizardException(String messagePattern, Throwable cause,
    Object[] args) {
    super(MessageFormat.format(messagePattern, args), cause);
  }

  /**
   * Cria uma exceo com a mensagem recebida e com a causa da exceo.
   *
   * @param message A mensagem da exceo.
   * @param cause A causa da exceo.
   */
  public WizardException(String message, Throwable cause) {
    super(message, cause);
  }
}
