/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.field;

import java.util.Date;
import java.util.Locale;
import javax.swing.text.Document;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.field.AbstractRegexField;
import tecgraf.javautils.gui.field.DateDocument;
import tecgraf.javautils.gui.field.DateListener;

public class DateField
extends AbstractRegexField {
    public DateField() {
        this(false);
    }

    public DateField(boolean showValidation) {
        this(LNG.getLocale(), showValidation);
    }

    public DateField(Locale locale) {
        this(locale, false);
    }

    public DateField(Locale locale, boolean showValidation) {
        super(showValidation);
        if (locale == null) {
            locale = LNG.getLocale();
        }
        this.setDocument(new DateDocument(locale));
        super.setLocale(locale);
        this.setToolTipText(this.getMask());
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.getDateDocument().setLocale(locale);
    }

    @Override
    public boolean isValidValue() {
        return this.getDateDocument().isValid();
    }

    @Deprecated
    public static boolean validateDate(String date, Locale locale) {
        return DateDocument.validateDateFormat(date, locale);
    }

    @Deprecated
    public static boolean validateDateFormat(String date, Locale locale) {
        return DateDocument.validateDateFormat(date, locale);
    }

    @Deprecated
    public static Date getDate(String date, Locale locale) {
        return DateDocument.getDate(date, locale);
    }

    public Integer getDay() {
        return this.getDateDocument().getDay();
    }

    public Integer getMonth() {
        return this.getDateDocument().getMonth();
    }

    public Integer getYear() {
        return this.getDateDocument().getYear();
    }

    public Long getDate() {
        return this.getDateDocument().getDate();
    }

    public void setAutoComplete(boolean complete) {
        if (complete) {
            this.getDateDocument().rebuildCompleText();
        } else {
            this.getDateDocument().setCompleteText(null);
        }
    }

    public void setDate(int day, int month, int year) {
        this.getDateDocument().setDate(day, month, year);
    }

    @Deprecated
    public static String toString(Locale locale, long date) {
        return DateDocument.toString(locale, date);
    }

    public void setDate(long lngDate) {
        this.getDateDocument().setDate(lngDate);
    }

    public void setToCurrentDate() {
        this.getDateDocument().setToCurrentDate();
    }

    public String getMask() {
        String lng = "tecgraf.javautils.gui.field.datefield.mask.";
        lng = lng + this.getDateDocument().getFormat().name().toLowerCase();
        return LNG.get((String)lng);
    }

    @Override
    public String toString() {
        return this.getText();
    }

    private DateDocument getDateDocument() {
        return (DateDocument)this.getDocument();
    }

    @Override
    public void setDocument(Document doc) {
        if (doc != null && doc instanceof DateDocument) {
            super.setDocument(doc);
        }
    }

    public void addDateListener(DateListener listener) {
        this.getDateDocument().addDateListener(listener);
    }

    public void removeDateListener(DateListener listener) {
        this.getDateDocument().removeDateListener(listener);
    }
}

