package tecgraf.javautils.gui;

import java.awt.GridBagLayout;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.WindowConstants;

/**
 * Exemplo de uso da classe {@link GBC}.
 *
 * @author Tecgraf/PUC-Rio
 */
public class GBCSample {

  /**
   * Mtodo para testes.
   * 
   * @param args <i>no usado</i>
   */
  public static void main(String[] args) {
    JFrame frame = new JFrame("GBC");
    frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);

    JPanel panel = new JPanel(new GridBagLayout());

    double wx1 = 0.1;
    double wx2 = 2.0;
    double wx3 = 1.0;

    double wx1_ = 1.5;
    double wx2_ = 1.0;

    panel.add(new JButton(Double.toString(wx1)), new GBC(0, 0).horizontal(wx1));
    panel.add(new JButton(Double.toString(wx2)), new GBC(1, 0).horizontal(wx2));
    panel.add(new JButton(Double.toString(wx3)), new GBC(2, 0).horizontal(wx3));

    panel.add(new JButton(Double.toString(wx1_)), new GBC(0, 1)
    .horizontal(wx1_).width(2));
    panel.add(new JButton(Double.toString(wx2_)), new GBC(2, 1)
    .horizontal(wx2_).left(10));

    final GBC gbc = new GBC(0, 2).center().horizontal(0.55).left(10).width(3);
    panel.add(new JButton(Double.toString(0.55)), gbc);

    System.out.println(gbc.toString());

    frame.add(panel);
    frame.pack();
    frame.setVisible(true);
    GUIUtils.centerOnScreen(frame);
  }
}
