/*
 * $Id: PrintableChartPanel.java 64881 2007-06-28 12:31:44Z letnog $
 */
package tecgraf.javautils.gui.print;

import java.awt.Graphics;
import java.awt.Paint;
import java.awt.print.PageFormat;

/**
 * Interface que define um painel de um grfico a ser impresso.
 */
public interface PrintableChartPanel {
  
  /**
   * Imprime o painel com o grfico.
   * 
   * @param g contexto grfico da impresso.
   * @param pf formato da pgina.
   * 
   * @return o resultado da impresso.
   */
  public int print(Graphics g, PageFormat pf);
  
  /**
   * Obtm o fundo do painel a ser impresso.
   * 
   * @return fundo do painel a ser impresso.
   */
  public Paint getBackgroundPaint();
  
  /**
   * Altera o fundo do painel a ser impresso.
   * 
   * @param paint fundo do painel a ser impresso.
   */
  public void setBackgroundPaint(Paint paint);
}
