package tecgraf.javautils.gui.selector;

import java.awt.BorderLayout;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

import javax.swing.JFrame;

import tecgraf.javautils.gui.table.DefaultObjectTableProvider;

/**
 * Exemplo de uso da classe {@link ContainerSelection}.
 *
 * @author Tecgraf/PUC-Rio
 */
public class ContainerSelectionSample {

  /**
   * Roda o teste do componente.
   * 
   * @param args .
   */
  public static void main(String[] args) {
    MyProvider provider = new MyProvider();
    ContainerSelection<TestObject> container =
      new ContainerSelection<TestObject>(provider);
    ArrayList<TestObject> availableElements = new ArrayList<TestObject>();
    Method[] methods = container.getClass().getDeclaredMethods();
    for (int i = 0; i < methods.length; i++) {
      TestObject obj = new TestObject();
      obj.id = i;
      obj.name = methods[i].getName();
      availableElements.add(obj);
    }
    container.loadItems(availableElements);
    JFrame frame = new JFrame("Teste");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.getContentPane().add(container.getPanel(), BorderLayout.CENTER);
    frame.pack();
    frame.setVisible(true);
    Collection<TestObject> availables = container.getSelectedItems();
    for (TestObject available : availables) {
      System.out.println("id: " + available.id + " | name: " + available.name);
    }
    Collection<TestObject> selecteds = container.getSelectedItems();
    for (TestObject selected : selecteds) {
      System.out.println("id: " + selected.id + " | name: " + selected.name);
    }
  }

  private static class TestObject {
    Integer id;
    String name;
  }

  private static class MyProvider extends DefaultObjectTableProvider {
    /**
     * {@inheritDoc}
     */
    public String[] getColumnNames() {
      return new String[] { "Identificador", "Nome" };
    }

    /**
     * {@inheritDoc}
     */
    public Class<?>[] getColumnClasses() {
      return new Class[] { Integer.class, String.class };
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Object[] getCellValues(Object row) {
      return new Object[] { ((TestObject) row).id, ((TestObject) row).name };
    }
  }
}
