package tecgraf.javautils.gui.table;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

/**
 * Exemplo de uso da classe {@link ColumnsObjectTableModel}.
 *
 * @author Tecgraf/PUC-Rio
 */
public class ColumnsObjectTableModelSample {

  public static void main(String[] args) {
    List<Person> phonebook = new ArrayList<Person>();
    phonebook.add(new Person("Pedro", 29));
    phonebook.add(new Person("Renata", 26));

    final TableModel model =
      new ColumnsObjectTableModel<Person>(phonebook, new NameColumn(),
        new AgeColumn());

    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.getContentPane().add(new JScrollPane(new JTable(model)));
        frame.pack();
        frame.setVisible(true);
      }
    });
  }

  /**
   * Classe que representa uma pessoa.
   *
   * @author Tecgraf
   */
  static class Person {
    /** Nome da pessoa. */
    private String name;
    /** Idade da pessoa. */
    private int age;

    /**
     * Construtor.
     * 
     * @param name Nome da pessoa.
     * @param age Idade da pessoa.
     */
    Person(String name, int age) {
      this.name = name;
      this.age = age;
    }
  }

  /**
   * Modelo da coluna que mostra o nome da {@link Person pessoa}.
   * 
   * @author Tecgraf
   */
  static class NameColumn extends AbstractColumn<Person> {
    /**
     * Construtor.
     */
    public NameColumn() {
      super(String.class);
    }

    /**
     * {@inheritDoc}
     */
    public String getColumnName() {
      return "Name";
    }

    /**
     * {@inheritDoc}
     */
    public Object getValue(Person obj) {
      return obj.name;
    }
  }

  /**
   * Modelo da coluna que mostra a idade da {@link Person pessoa}.
   * 
   * @author Tecgraf
   */
  static class AgeColumn extends AbstractColumn<Person> {
    /**
     * Construtor.
     */
    public AgeColumn() {
      super(Integer.class);
    }

    /**
     * {@inheritDoc}
     */
    public String getColumnName() {
      return "Age";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isEditable(Person obj) {
      return true;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setValue(Person obj, Object value) {
      obj.age = (Integer) value;
    }

    /**
     * {@inheritDoc}
     */
    public Object getValue(Person obj) {
      return obj.age;
    }
  }
}
