package tecgraf.javautils.gui.table;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

/**
 * Modelo da coluna de uma tabela de objetos.<br>
 * Os objetos so representados pelas linhas da tabela e as colunas representam
 * suas propriedades.
 * 
 * @param <O> Tipo do objeto representado pela linha da tabela.
 * 
 * @author Tecgraf / PUC-Rio
 */
public interface IColumn<O> {

  /**
   * Obtm a classe da propriedade de {@code <R>} que  representada por esta coluna.
   * 
   * @return a classe da propriedade de {@code <R>} que  representada por esta coluna.
   */
  public abstract Class<?> getColumnClass();

  /**
   * Obtm o nome da coluna.
   * 
   * @return o nome da coluna.
   */
  public abstract String getColumnName();

  /**
   * Obtm o renderizador de clulas para esta coluna.
   * 
   * @return o renderizador de clulas para esta coluna. Caso seja nulo, ser
   *         utilizado o renderizador padro da tabela.
   */
  public abstract TableCellRenderer createTableCellRenderer();

  /**
   * Obtm o editor de clulas para esta coluna.
   * 
   * @return o editor de clulas para esta coluna. Caso seja nulo, ser
   *         utilizado o editor padro da tabela.
   */
  public abstract TableCellEditor createTableCellEditor();

  /**
   * Indica se uma dada clula da tabela  editvel.<br>
   * Essa clula  a propriedade representada por esta coluna, em um objeto
   * representado por uma linha especfica da tabela.
   * 
   * @param obj objeto representado por uma linha da tabela, o qual se deseja
   *        saber se sua propriedade, representada por esta coluna,  editvel.
   * 
   * @return <tt>true</tt> se a propriedade do objeto, representada por esta
   *         coluna, for editvel.
   */
  public abstract boolean isEditable(O obj);

  /**
   * Altera o valor da propriedade do objeto, representada por esta coluna.
   * 
   * @param obj objeto representado por uma linha da tabela, ao qual se deseja
   *        obter atribuir valor a propriedade representada por esta coluna.
   * 
   * @param value o novo valor da propriedade do objeto, representada por esta
   *        coluna.
   */
  public abstract void setValue(O obj, Object value);

  /**
   * Obtm o valor da propriedade do objeto, representada por esta coluna.
   * 
   * @param obj objeto representado por uma linha da tabela, do qual se deseja
   *        obter a propriedade representada por esta coluna.
   * 
   * @return o valor da propriedade do objeto, representada por esta coluna.
   */
  public abstract Object getValue(O obj);
}
