/*
 * $Id: TotalizerModelWrapper.java 113842 2010-12-18 22:52:52Z gazevedo $
 */
package tecgraf.javautils.gui.table;

import java.util.HashMap;
import java.util.Map;

import javax.swing.table.TableModel;

/**
 * Classe que "decora" ou "engloba" um modelo (<i>Wrapper</i>), totalizando as
 * colunas especificadas e exibindo o resultado na ltima linha. A primeira
 * coluna desta ltima linha  reservada para a exibio de um texto, por
 * exemplo "Total".
 * 
 * @author Tecgraf
 */
public class TotalizerModelWrapper extends FooterModelWrapper {
  /** Colunas a terem os totais apresentados */
  private int[] totalColumns;

  /**
   * Cria o decorador de modelo, indicando quais as colunas a serem totalizadas
   * e qual o texto a ser exibido na primeira coluna da ltima linha.
   * 
   * @param model modelo a ser decorado.
   * @param totalColumns ndice das colunas que devem ser totalizadas.
   * @param totalText texto a ser exibido na primeira coluna da ltima linha.
   */
  public TotalizerModelWrapper(TableModel model, int[] totalColumns,
    String totalText) {
    super(model, totalText);
    this.totalColumns = totalColumns;
  }

  /**
   * Calcula a soma dos valores do modelo decorado, para determinadas colunas.
   */
  @Override
  protected Map<Integer, Number> getFooterValues() {
    Map<Integer, Number> footerValues = new HashMap<Integer, Number>();
    for (int i = 0; i < totalColumns.length; i++) {
      int columnIndex = totalColumns[i];
      double total = 0;
      for (int row = 0; row < getModel().getRowCount(); row++) {
        Object value = getModel().getValueAt(row, columnIndex);
        if (!Number.class.isInstance(value)) {
          continue;
        }
        total += Double.valueOf(value.toString());
      }
      footerValues.put(columnIndex, total);
    }
    return footerValues;
  }
}
