package tecgraf.javautils.gui.wizard.utils.changedlisteners;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.WasChangedListener;

/**
 * Representa um ouvinte de eventos de mudana de estado que notifica a um passo
 * que tal evento ocorreu.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class WasChangedChangeListener extends WasChangedListener
  implements ChangeListener {

  /**
   * {@inheritDoc}
   */
  @Override
  public void stateChanged(ChangeEvent e) {
    notifyChangedToStep();
  }

  /**
   * Cria um ouvinte de eventos de mudana de estado que notificar a um passo
   * da ocorrncia desse evento.
   *
   * @param step O passo a ser notificado.
   */
  public WasChangedChangeListener(Step step) {
    super(step);
  }
}
