/*
 * $Id: PageSeparator.java 138821 2013-03-11 17:32:49Z allan $
 */
package tecgraf.javautils.gui.print;

import java.awt.Graphics2D;
import java.awt.print.PageFormat;

/**
 * Imprime um espaamento com a altura da pgina.
 */
public class PageSeparator implements PrintableReportItem {
  /** Altura do espaamento */
  private float height;

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean simulatePrint(Graphics2D g2, PageFormat format, int pageIndex) {
    return printPageSeparator(format);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean print(Graphics2D g2, PageFormat format, int pageIndex) {
    return printPageSeparator(format);
  }

  /**
   * Imprime o separador de pginas.
   * 
   * @param format formato da pgina a ser impressa.
   * 
   * @return verdadeiro se o separador foi impresso.
   */
  private boolean printPageSeparator(PageFormat format) {
    height = (float) format.getImageableHeight();
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public float getHeight() {
    return height;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void initPrinting(PrintConfiguration configuration) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public float getWidth() {
    // TODO Auto-generated method stub
    return 0;
  }
}
