package tecgraf.javautils.gui.table;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;

/**
 * Exemplo de uso da classe {@link TotalizerModelWrapper}.
 *
 * @author Tecgraf/PUC-Rio
 */
public class TotalizerModelWrapperSample {
  
  /**
   * Teste para a classe.
   * 
   * @param args parmetros da linha de comando (no usados).
   */
  public static void main(String[] args) {
    // Tabela
    final TotalizerModelWrapper modelWrapper =
      new TotalizerModelWrapper(new TestModel(), new int[] { 2, 3 }, "Total");
    final SortableTable table = new SortableTable(modelWrapper, true);

    //    table.sort();
    table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    table.adjustColumnWidth();
    JComponent tablePane = new JScrollPane(table);

    // Painel de Botes
    JButton buttonNewRow = new JButton("Nova linha");
    buttonNewRow.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        ((TestModel) modelWrapper.getModel()).addRow("F", "Pablo", 23);
      }
    });
    JPanel buttonPanel = new JPanel();
    buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.Y_AXIS));
    buttonPanel.add(buttonNewRow);

    // Janela
    JFrame frame = new JFrame("Totalizer 1.6");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.add(tablePane, BorderLayout.CENTER);
    frame.add(buttonPanel, BorderLayout.WEST);
    int width = 650;
    int height = 400;
    frame.setSize(width, height);
    final int FRAME_INTERNAL_MARGIN = 13; // Margem interna a ser descontada
    table.setPreferredScrollableViewportSize(new Dimension(width
      - FRAME_INTERNAL_MARGIN,
      table.getPreferredScrollableViewportSize().height));
    frame.setVisible(true);
  }

  /**
   * Classe interna que fornece um modelo qualquer para teste.
   */
  private static class TestModel extends AbstractTableModel {
    /** Matriz que representa os elementos da tabela */
    List<List<?>> values = new ArrayList<List<?>>();

    /** Array de cabealhos das colunas */
    String[] headers = new String[] { "Col A", "Col B", "Col C", "Col D" };

    /**
     * Constri o modelo.
     */
    public TestModel() {
      values.add(Arrays
        .asList(new Object[] { "A", "Joo", new Float(2.15), 0 }));
      values
        .add(Arrays.asList(new Object[] { "D", "J", new Float(1.335), 1 }));
      values.add(Arrays.asList(new Object[] { "g", "Romo", 2.23f, 2 }));
      values.add(Arrays.asList(new Object[] { "v", "Luis", 11f, 3 }));
      values.add(Arrays.asList(new Object[] { "E", "", null, 4 }));
      values.add(Arrays
        .asList(new Object[] { "S", null, new Float(665.5524), 5 }));
      values.add(Arrays.asList(new Object[] { "Z", null, null, 6 }));
    }

    /**
     * Adiciona uma linha ao modelo.
     * 
     * @param letter letra qualquer.
     * @param name nome qualquer.
     * @param number nmero inteiro ou fracionrio.
     */
    public void addRow(String letter, String name, float number) {
      int newIndex = values.size();
      values
        .add(Arrays.asList(new Object[] { letter, name, number, newIndex }));
      fireTableRowsInserted(newIndex, newIndex);
    }

    /**
     * {@inheritDoc}
     */
    public int getRowCount() {
      return values.size();
    }

    /**
     * {@inheritDoc}
     */
    public int getColumnCount() {
      return values.get(0).size();
    }

    /**
     * {@inheritDoc}
     */
    public Object getValueAt(int rowIndex, int columnIndex) {
      return values.get(rowIndex).get(columnIndex);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getColumnName(int columnIndex) {
      return headers[columnIndex];
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Class<?> getColumnClass(int columnIndex) {
      return (values.get(0).get(columnIndex)).getClass();
    }
  }
}
