package tecgraf.javautils.gui.wizard.utils.changedlisteners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.WasChangedListener;

/**
 * Representa um ouvinte de eventos de ao que notifica a um passo que tal
 * evento ocorreu.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class WasChangedActionListener extends WasChangedListener
  implements ActionListener {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    notifyChangedToStep();
  }

  /**
   * Cria um ouvinte de eventos de ao que notificar a um passo da ocorrncia
   * desse evento.
   *
   * @param step o passo a ser notificado.
   */
  public WasChangedActionListener(Step step) {
    super(step);
  }
}
