/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIResources;
import tecgraf.javautils.gui.MenuButton;

public class MenuButtonSample {
    public static void main(String[] args) {
        JFrame frame = new JFrame("Teste para MenuButton");
        frame.setDefaultCloseOperation(3);
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        MenuButton bottom1 = MenuButtonSample.createTestButton("Bottom", MenuButton.PopupPosition.BOTTOM, true);
        contentPane.add((Component)bottom1, new GBC(0, 0).northwest().pushxy());
        MenuButton bottom2 = MenuButtonSample.createTestButton("Bottom", MenuButton.PopupPosition.BOTTOM, false);
        contentPane.add((Component)bottom2, new GBC(1, 0).north().pushxy());
        MenuButton left = MenuButtonSample.createTestButton(GUIResources.BUTTON_CALENDAR_ICON, MenuButton.PopupPosition.LEFT, false);
        contentPane.add((Component)left, new GBC(2, 0).northeast().pushxy());
        MenuButton up1 = MenuButtonSample.createTestButton(GUIResources.BUTTON_CALENDAR_ICON, MenuButton.PopupPosition.TOP, false);
        contentPane.add((Component)up1, new GBC(0, 1).southwest().pushxy());
        MenuButton right = MenuButtonSample.createTestButton("Right", MenuButton.PopupPosition.RIGHT, false);
        contentPane.add((Component)right, new GBC(1, 1).south().pushxy());
        MenuButton up2 = MenuButtonSample.createTestButton(GUIResources.BUTTON_CALENDAR_ICON, MenuButton.PopupPosition.TOP, true);
        contentPane.add((Component)up2, new GBC(2, 1).southeast().pushxy());
        frame.setSize(450, 150);
        frame.setVisible(true);
    }

    private static MenuButton createTestButton(ImageIcon icon, MenuButton.PopupPosition pos, boolean alignRight) {
        return MenuButtonSample.addTestActions(new MenuButton(icon, pos, alignRight));
    }

    private static MenuButton createTestButton(String label, MenuButton.PopupPosition pos, boolean alignRight) {
        return MenuButtonSample.addTestActions(new MenuButton(label, pos, alignRight));
    }

    private static MenuButton addTestActions(MenuButton menuButton) {
        menuButton.add(new JMenuItem(new AbstractAction("item 1"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("executando item 1...");
            }
        }));
        menuButton.add(new AbstractAction("item 2"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("executando item 2...");
            }
        });
        return menuButton;
    }
}

