/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.parser;

import java.util.ArrayList;
import java.util.List;
import tecgraf.javautils.jexpression.exception.JExpressionSyntaxErrorException;
import tecgraf.javautils.jexpression.scanner.JScanner;
import tecgraf.javautils.jexpression.scanner.Symbol;
import tecgraf.javautils.jexpression.scanner.Token;

class TokenMemoization {
    private JScanner scanner;
    private List<Token> tokens;
    private int index;

    TokenMemoization(String string) {
        if (string == null) {
            throw new IllegalArgumentException("input n\u00e3o pode ser nulo.");
        }
        this.scanner = new JScanner(string);
        this.tokens = new ArrayList<Token>();
        this.index = 0;
    }

    Token token() throws JExpressionSyntaxErrorException {
        if (this.index >= this.tokens.size()) {
            for (int i = 0; i <= this.index - this.tokens.size(); ++i) {
                Token token = this.scanner.nextToken();
                if (token == null) {
                    return null;
                }
                if (token.isUnknown()) {
                    String string = "Caracter desconhecido '%s'";
                    String string2 = String.format(string, token.getValue());
                    throw new JExpressionSyntaxErrorException(string2, token.getLineNumber());
                }
                this.tokens.add(token);
            }
        }
        return this.tokens.get(this.index);
    }

    boolean isTerminal(Symbol ... symbolArray) throws JExpressionSyntaxErrorException {
        Token token = this.token();
        if (token == null) {
            return false;
        }
        for (Symbol symbol : symbolArray) {
            if (symbol != token.getType()) continue;
            return true;
        }
        return false;
    }

    boolean hasMoreTokens() throws JExpressionSyntaxErrorException {
        return this.token() != null;
    }

    void commit() {
        ++this.index;
    }

    void rollback() {
        if (this.index != 0) {
            --this.index;
        }
    }
}

