/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.jexpression.JExpressionHandler;
import tecgraf.javautils.jexpression.exception.JExpressionException;
import tecgraf.javautils.jexpression.util.function.JExpressionFunction;
import tecgraf.javautils.jexpression.util.function.MathDoubleFunctions;
import tecgraf.javautils.jexpression.util.function.MathSingleFunctions;

public class CalculatorHandler
implements JExpressionHandler {
    private double tolerance;
    private Map<String, Object> vars;
    private Map<String, JExpressionFunction> functions;

    public CalculatorHandler() {
        this(1.0E-6);
    }

    public CalculatorHandler(double d) {
        this.tolerance = d;
        this.vars = new HashMap<String, Object>();
        this.functions = new HashMap<String, JExpressionFunction>();
        this.registerDefaultFunctions();
    }

    public void addVariable(String string, Object object) {
        this.vars.put(string, object);
    }

    public boolean hasVariable(String string) {
        return this.vars.containsKey(string);
    }

    public void addFunction(JExpressionFunction jExpressionFunction) {
        this.functions.put(jExpressionFunction.getName(), jExpressionFunction);
    }

    public boolean hasFunction(String string) {
        return this.functions.containsKey(string);
    }

    public List<String> getVarNames() {
        return new ArrayList<String>(this.vars.keySet());
    }

    public List<String> getFunctionNames() {
        return new ArrayList<String>(this.functions.keySet());
    }

    @Override
    public Object handleDouble(Double d) throws Exception {
        return d;
    }

    @Override
    public Object handlePlus(Object object, Object object2) throws Exception {
        if (object instanceof Double && object2 instanceof Double) {
            return (Double)object + (Double)object2;
        }
        String string = "('+') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handleMinus(Object object, Object object2) throws Exception {
        if (object instanceof Double && object2 instanceof Double) {
            return (Double)object - (Double)object2;
        }
        String string = "('-') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handleTimes(Object object, Object object2) throws Exception {
        if (object instanceof Double && object2 instanceof Double) {
            return (Double)object * (Double)object2;
        }
        String string = "('*') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handleDivision(Object object, Object object2) throws Exception {
        if (object instanceof Double && object2 instanceof Double) {
            return (Double)object / (Double)object2;
        }
        String string = "('/') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handlePow(Object object, Object object2) throws Exception {
        if (object instanceof Double && object2 instanceof Double) {
            return Math.pow((Double)object, (Double)object2);
        }
        String string = "('^') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handleOr(Object object, Object object2) throws Exception {
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return (Boolean)object != false || (Boolean)object2 != false;
        }
        String string = "('||') Erro na convers\u00e3o dos valores '%s' e '%s' para boleano.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handleAnd(Object object, Object object2) throws Exception {
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return (Boolean)object != false && (Boolean)object2 != false;
        }
        String string = "('&&') Erro na convers\u00e3o dos valores '%s' e '%s' para boleano.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handleEqual(Object object, Object object2) throws Exception {
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return ((Boolean)object).equals(object2);
        }
        if (object instanceof Double && object2 instanceof Double) {
            return this.eq((Double)object, (Double)object2);
        }
        String string = "Erro na verifica\u00e7\u00e3o de igualdade dos valores '%s' e '%s'.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handleNotEqual(Object object, Object object2) throws Exception {
        Boolean bl = (Boolean)this.handleEqual(object, object2);
        return bl == false;
    }

    @Override
    public Object handleGreater(Object object, Object object2) throws Exception {
        if (object instanceof Double && object2 instanceof Double) {
            return (Double)object > (Double)object2;
        }
        String string = "('>') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handleGreaterEqual(Object object, Object object2) throws Exception {
        if (object instanceof Double && object2 instanceof Double) {
            double d;
            double d2 = (Double)object;
            return d2 >= (d = ((Double)object2).doubleValue()) || this.eq(d2, d);
        }
        String string = "('>=') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handleLower(Object object, Object object2) throws Exception {
        if (object instanceof Double && object2 instanceof Double) {
            return (Double)object < (Double)object2;
        }
        String string = "('<') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handleLowerEqual(Object object, Object object2) throws Exception {
        if (object instanceof Double && object2 instanceof Double) {
            double d;
            double d2 = (Double)object;
            return d2 <= (d = ((Double)object2).doubleValue()) || this.eq(d2, d);
        }
        String string = "('<=') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(string, object, object2));
    }

    @Override
    public Object handleQuestion(Object object, Object object2, Object object3) throws Exception {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? object2 : object3;
        }
        String string = "('?') Erro na convers\u00e3o da condi\u00e7\u00e3o '%s' para boleano.";
        throw new JExpressionException(String.format(string, object));
    }

    @Override
    public Object handleUnaryMinus(Object object) throws Exception {
        if (object instanceof Double) {
            return -((Double)object).doubleValue();
        }
        String string = "('-' un\u00e1rio) Erro na convers\u00e3o do valor '%s' para double.";
        throw new JExpressionException(String.format(string, object));
    }

    @Override
    public Object handleNot(Object object) throws Exception {
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        String string = "('!') Erro na convers\u00e3o o valor '%s' para boleano.";
        throw new JExpressionException(String.format(string, object));
    }

    @Override
    public Object handleVar(String string) throws Exception {
        if (!this.hasVariable(string)) {
            String string2 = "Vari\u00e1vel '%s' n\u00e3o foi definida.";
            throw new JExpressionException(String.format(string2, string));
        }
        return this.vars.get(string);
    }

    @Override
    public Object handleFunctionCall(String string, List<Object> list) throws Exception {
        if (!this.hasFunction(string)) {
            String string2 = "Fun\u00e7\u00e3o '%s' n\u00e3o foi definida.";
            throw new JExpressionException(String.format(string2, string));
        }
        JExpressionFunction jExpressionFunction = this.functions.get(string);
        return jExpressionFunction.call(list.toArray());
    }

    @Override
    public Object handleIndex(Object object, Object object2) throws Exception {
        return null;
    }

    @Override
    public Object handleField(Object object, String string) throws Exception {
        return null;
    }

    private boolean eq(double d, double d2) {
        return d == d2 || Math.abs(d - d2) <= this.tolerance;
    }

    private void registerDefaultFunctions() {
        JExpressionFunction jExpressionFunction;
        for (MathSingleFunctions enum_ : MathSingleFunctions.values()) {
            jExpressionFunction = enum_.getFunction();
            this.functions.put(jExpressionFunction.getName(), jExpressionFunction);
        }
        for (Enum enum_ : MathDoubleFunctions.values()) {
            jExpressionFunction = ((MathDoubleFunctions)enum_).getFunction();
            this.functions.put(jExpressionFunction.getName(), jExpressionFunction);
        }
    }
}

