package tecgraf.javautils.jexpression.parser.model;

import tecgraf.javautils.jexpression.scanner.Symbol;

/**
 * /** Classe que armazena uma operao unria. As operaes unrias possveis
 * so as seguintes: "-" e "!"
 * 
 * Abaixo listamos os outros tipos de operadores da linguagem.
 * 
 * Operador ternrio: {@link Question} <br/>
 * Operador de acesso a campo: {@link Field} <br/>
 * Operadores binrios: {@link BinaryOp}
 * 
 * Ex: !a, -a, !!a, --a
 * 
 * @author Tecgraf
 */
public class UnaryOp extends Exp {

  /** Operador. */
  private Symbol op;

  /** Operando. */
  private Exp expression;

  /**
   * Construtor.
   * 
   * @param op operador.
   * @param expression operando.
   */
  public UnaryOp(Symbol op, Exp expression) {
    if (op == null) {
      throw new IllegalArgumentException("op no pode ser nulo.");
    }
    if (expression == null) {
      throw new IllegalArgumentException("expression no pode ser nulo.");
    }
    this.op = op;
    this.expression = expression;
  }

  /**
   * Operador.
   * 
   * @return operador.
   */
  public Symbol getOp() {
    return op;
  }

  /**
   * Operando.
   * 
   * @return operando.
   */
  public Exp getExpression() {
    return expression;
  }

  /** {@inheritDoc} */
  @Override
  public String toString() {
    String op = getOp().graphic;
    return String.format("%s%s", op, expression);
  }

}
