package tecgraf.javautils.jexpression.util.function;

/**
 * Funo que recebe dois parmetros.
 * 
 * @param <T> tipo do parmetro.
 * 
 * @author Tecgraf
 */
public abstract class JExpressionDoubleFunction<T> extends JExpressionFunction {

  /**
   * Construtor.
   * 
   * @param name nome.
   */
  public JExpressionDoubleFunction(String name) {
    super(name);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  @SuppressWarnings("unchecked")
  public Object call(Object... params) {
    if (params.length != 2) {
      String f = "Funo '%s' deve receber dois parmetro.";
      throw new IllegalArgumentException(String.format(f, getName()));
    }
    return invoke((T) params[0], (T) params[1]);
  }

  /**
   * Executa a chamada da funo.
   * 
   * @param first primeiro parmetro.
   * @param second segundo parmetro.
   * @return resultado da chamada de funo.
   */
  public abstract Object invoke(T first, T second);
}
