package tecgraf.javautils.jexpression.util.function;

/**
 * Funo que recebe um parmetro.
 * 
 * @param <T> tipo do parmetro.
 * 
 * @author Tecgraf
 */
public abstract class JExpressionSingleFunction<T> extends JExpressionFunction {

  /**
   * Construtor.
   * 
   * @param name nome.
   */
  public JExpressionSingleFunction(String name) {
    super(name);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  @SuppressWarnings("unchecked")
  public Object call(Object... params) {
    if (params.length != 1) {
      String f = "Funo '%s' deve receber um parmetro.";
      throw new IllegalArgumentException(String.format(f, getName()));
    }
    return invoke((T) params[0]);
  }

  /**
   * Executa a chamada da funo.
   * 
   * @param param parmetro.
   * @return resultado da chamada de funo.
   */
  public abstract Object invoke(T param);
}
