package tecgraf.javautils.jexpression.util.function;

/**
 * Conjunto de funes pr-definidas que recebem dois parmetros do tipo
 * {@link Double}.
 * 
 * @author Tecgraf
 */
public enum MathDoubleFunctions {

  /** max. */
  MAX {
    @Override
    public JExpressionDoubleFunction<Double> getFunction() {
      return new JExpressionDoubleFunction<Double>("max") {
        @Override
        public Double invoke(Double first, Double second) {
          return Math.max(first, second);
        }
      };
    }
  },

  /** min. */
  MIN {
    @Override
    public JExpressionDoubleFunction<Double> getFunction() {
      return new JExpressionDoubleFunction<Double>("min") {
        @Override
        public Double invoke(Double first, Double second) {
          return Math.min(first, second);
        }
      };
    }
  };

  /**
   * Funo.
   * 
   * @return funo.
   */
  abstract public JExpressionDoubleFunction<Double> getFunction();
}
