/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.samples;

import java.util.Scanner;
import tecgraf.javautils.jexpression.JExpression;
import tecgraf.javautils.jexpression.util.CalculatorHandler;

public class Calculator {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        CalculatorHandler handler = new CalculatorHandler();
        while (true) {
            System.out.println("Digite express\u00e3o (op\u00e7\u00f5es: 'help' e 'exit'):");
            String line = scanner.nextLine();
            if (line.contains("help")) {
                System.out.println("Para definir vari\u00e1veis: define <nome> <valor>");
                continue;
            }
            if (line.contains("define")) {
                String[] values = line.split(" +");
                if (values.length != 3) {
                    System.out.println("Opera\u00e7\u00e3o 'define' requer 2 argumentos.");
                    continue;
                }
                Object value = Calculator.getValue(values[2]);
                handler.addVariable(values[1], value);
                continue;
            }
            if (line.contains("exit")) break;
            Calculator.evaluate(line, handler);
        }
    }

    private static Object getValue(String value) {
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        return Double.valueOf(value);
    }

    private static void evaluate(String entry, CalculatorHandler handler) {
        try {
            JExpression expression = JExpression.compile(entry);
            Object result = expression.eval(handler);
            System.out.println(result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

