/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.scanner;

import java.util.regex.Pattern;

public enum Symbol {
    GREATER_EQ(">=", ">="),
    GREATER(">", ">"),
    LOWER_EQ("<=", "<="),
    LOWER("<", "<"),
    PLUS("+", "\\+"),
    COMMA(",", ","),
    MINUS("-", "\\-"),
    DIVIDE("/", "\\/"),
    TIMES("*", "\\*"),
    POW("^", "\\^"),
    QUESTION("?", "\\?"),
    COLON(":", ":"),
    L_PAREN("(", "\\("),
    R_PAREN(")", "\\)"),
    L_BRACKET("[", "\\["),
    R_BRACKET("]", "\\]"),
    EQUAL("==", "=="),
    NOT_EQUAL("!=", "!="),
    NOT("!", "!"),
    AND("&&", "\\&\\&"),
    OR("||", "\\|\\|"),
    DOT(".", "\\."),
    DOUBLE(null, "[0-9]*\\.[0-9]+([Ee][+-]?[0-9]+)?|[0-9]+"),
    NAME(null, "[_a-zA-Z][_a-zA-Z0-9]*"),
    UNKNOWN(null, ".");

    public final String graphic;
    public final Pattern pattern;

    private Symbol(String graphic, String regex) {
        this.graphic = graphic;
        this.pattern = Pattern.compile(String.format("^(%s)", regex));
    }
}

