/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.jexpression.JExpressionHandler;
import tecgraf.javautils.jexpression.exception.JExpressionException;
import tecgraf.javautils.jexpression.util.function.JExpressionFunction;
import tecgraf.javautils.jexpression.util.function.MathDoubleFunctions;
import tecgraf.javautils.jexpression.util.function.MathSingleFunctions;

public class CalculatorHandler
implements JExpressionHandler {
    private double tolerance;
    private Map<String, Object> vars;
    private Map<String, JExpressionFunction> functions;

    public CalculatorHandler() {
        this(1.0E-6);
    }

    public CalculatorHandler(double tolerance) {
        this.tolerance = tolerance;
        this.vars = new HashMap<String, Object>();
        this.functions = new HashMap<String, JExpressionFunction>();
        this.registerDefaultFunctions();
    }

    public void addVariable(String name, Object value) {
        this.vars.put(name, value);
    }

    public boolean hasVariable(String name) {
        return this.vars.containsKey(name);
    }

    public void addFunction(JExpressionFunction function) {
        this.functions.put(function.getName(), function);
    }

    public boolean hasFunction(String name) {
        return this.functions.containsKey(name);
    }

    public List<String> getVarNames() {
        return new ArrayList<String>(this.vars.keySet());
    }

    public List<String> getFunctionNames() {
        return new ArrayList<String>(this.functions.keySet());
    }

    @Override
    public Object handleDouble(Double value) throws Exception {
        return value;
    }

    @Override
    public Object handlePlus(Object first, Object second) throws Exception {
        if (first instanceof Double && second instanceof Double) {
            return (Double)first + (Double)second;
        }
        String f = "('+') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handleMinus(Object first, Object second) throws Exception {
        if (first instanceof Double && second instanceof Double) {
            return (Double)first - (Double)second;
        }
        String f = "('-') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handleTimes(Object first, Object second) throws Exception {
        if (first instanceof Double && second instanceof Double) {
            return (Double)first * (Double)second;
        }
        String f = "('*') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handleDivision(Object first, Object second) throws Exception {
        if (first instanceof Double && second instanceof Double) {
            return (Double)first / (Double)second;
        }
        String f = "('/') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handlePow(Object first, Object second) throws Exception {
        if (first instanceof Double && second instanceof Double) {
            return Math.pow((Double)first, (Double)second);
        }
        String f = "('^') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handleOr(Object first, Object second) throws Exception {
        if (first instanceof Boolean && second instanceof Boolean) {
            return (Boolean)first != false || (Boolean)second != false;
        }
        String f = "('||') Erro na convers\u00e3o dos valores '%s' e '%s' para boleano.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handleAnd(Object first, Object second) throws Exception {
        if (first instanceof Boolean && second instanceof Boolean) {
            return (Boolean)first != false && (Boolean)second != false;
        }
        String f = "('&&') Erro na convers\u00e3o dos valores '%s' e '%s' para boleano.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handleEqual(Object first, Object second) throws Exception {
        if (first instanceof Boolean && second instanceof Boolean) {
            return ((Boolean)first).equals(second);
        }
        if (first instanceof Double && second instanceof Double) {
            return this.eq((Double)first, (Double)second);
        }
        String f = "Erro na verifica\u00e7\u00e3o de igualdade dos valores '%s' e '%s'.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handleNotEqual(Object first, Object second) throws Exception {
        Boolean result = (Boolean)this.handleEqual(first, second);
        return result == false;
    }

    @Override
    public Object handleGreater(Object first, Object second) throws Exception {
        if (first instanceof Double && second instanceof Double) {
            return (Double)first > (Double)second;
        }
        String f = "('>') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handleGreaterEqual(Object first, Object second) throws Exception {
        if (first instanceof Double && second instanceof Double) {
            double b;
            double a = (Double)first;
            return a >= (b = ((Double)second).doubleValue()) || this.eq(a, b);
        }
        String f = "('>=') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handleLower(Object first, Object second) throws Exception {
        if (first instanceof Double && second instanceof Double) {
            return (Double)first < (Double)second;
        }
        String f = "('<') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handleLowerEqual(Object first, Object second) throws Exception {
        if (first instanceof Double && second instanceof Double) {
            double b;
            double a = (Double)first;
            return a <= (b = ((Double)second).doubleValue()) || this.eq(a, b);
        }
        String f = "('<=') Erro na convers\u00e3o dos valores '%s' e '%s' para double.";
        throw new JExpressionException(String.format(f, first, second));
    }

    @Override
    public Object handleQuestion(Object condition, Object then, Object otherwise) throws Exception {
        if (condition instanceof Boolean) {
            return (Boolean)condition != false ? then : otherwise;
        }
        String f = "('?') Erro na convers\u00e3o da condi\u00e7\u00e3o '%s' para boleano.";
        throw new JExpressionException(String.format(f, condition));
    }

    @Override
    public Object handleUnaryMinus(Object object) throws Exception {
        if (object instanceof Double) {
            return -((Double)object).doubleValue();
        }
        String f = "('-' un\u00e1rio) Erro na convers\u00e3o do valor '%s' para double.";
        throw new JExpressionException(String.format(f, object));
    }

    @Override
    public Object handleNot(Object object) throws Exception {
        if (object instanceof Boolean) {
            return (Boolean)object == false;
        }
        String f = "('!') Erro na convers\u00e3o o valor '%s' para boleano.";
        throw new JExpressionException(String.format(f, object));
    }

    @Override
    public Object handleVar(String name) throws Exception {
        if (!this.hasVariable(name)) {
            String f = "Vari\u00e1vel '%s' n\u00e3o foi definida.";
            throw new JExpressionException(String.format(f, name));
        }
        return this.vars.get(name);
    }

    @Override
    public Object handleFunctionCall(String functionName, List<Object> params) throws Exception {
        if (!this.hasFunction(functionName)) {
            String f = "Fun\u00e7\u00e3o '%s' n\u00e3o foi definida.";
            throw new JExpressionException(String.format(f, functionName));
        }
        JExpressionFunction function = this.functions.get(functionName);
        return function.call(params.toArray());
    }

    @Override
    public Object handleIndex(Object object, Object index) throws Exception {
        return null;
    }

    @Override
    public Object handleField(Object object, String field) throws Exception {
        return null;
    }

    private boolean eq(double a, double b) {
        return a == b || Math.abs(a - b) <= this.tolerance;
    }

    private void registerDefaultFunctions() {
        JExpressionFunction function;
        for (MathSingleFunctions mathSingleFunctions : MathSingleFunctions.values()) {
            function = mathSingleFunctions.getFunction();
            this.functions.put(function.getName(), function);
        }
        for (Enum enum_ : MathDoubleFunctions.values()) {
            function = ((MathDoubleFunctions)enum_).getFunction();
            this.functions.put(function.getName(), function);
        }
    }
}

