package tecgraf.javautils.jexpression.exception;

import tecgraf.javautils.jexpression.parser.JParser;

/**
 * Exceo que sinaliza erro de sintaxe. Essa exceo  lanada durante o
 * processo de parsing feito pelo {@link JParser}.
 * 
 * @author Tecgraf
 */
public class JExpressionSyntaxErrorException extends JExpressionException {

  /** Nmero da linha. */
  private int lineNumber;

  /**
   * Construtor.
   * 
   * @param msg mensagem.
   * @param lineNumber nmero da linha.
   */
  public JExpressionSyntaxErrorException(String msg, int lineNumber) {
    super(msg);
    if (lineNumber < 0) {
      throw new IllegalArgumentException("lineNumber no pode ser negativo.");
    }
    this.lineNumber = lineNumber;
  }

  /**
   * Nmero da linha do erro de sintaxe.
   * 
   * @return nmero da linha.
   */
  public int getLineNumber() {
    return lineNumber;
  }

  /** {@inheritDoc} */
  @Override
  public String getMessage() {
    String f = "%s; linha: %s;";
    return String.format(f, super.getMessage(), lineNumber);
  }
}
