package tecgraf.javautils.jexpression.parser.model;

import tecgraf.javautils.jexpression.scanner.Symbol;

/**
 * Classe que armazena uma operao binria. As operaes binrias possveis so
 * listadas abaixo:
 * 
 * Operadores relacionais: "<=", "<", ">=", ">", "==", "!=", "&&", "||" <br/>
 * Operadores aritmticos: "+", "-", "*", "/", "^" <br/>
 * 
 * Abaixo listamos os outros tipos de operadores da linguagem.
 * 
 * Operador ternrio: {@link Question} <br/>
 * Operador de acesso a campo: {@link Field} <br/>
 * Operadores unrios: {@link UnaryOp}
 * 
 * Ex: a <= b, a + b * c, a || b, a == b, a != b
 * 
 * @author Tecgraf
 */
public class BinaryOp extends Exp {

  /** Primeiro operando. */
  private Exp first;

  /** Operador. */
  private Symbol op;

  /** Segundo operando. */
  private Exp second;

  /**
   * Construtor.
   * 
   * @param first primeiro operando.
   * @param op operador.
   * @param second segundo operando
   */
  public BinaryOp(Exp first, Symbol op, Exp second) {
    if (first == null) {
      throw new IllegalArgumentException("first no pode ser nulo.");
    }
    if (op == null) {
      throw new IllegalArgumentException("op no pode ser nulo.");
    }
    if (second == null) {
      throw new IllegalArgumentException("second no pode ser nulo.");
    }
    this.first = first;
    this.op = op;
    this.second = second;
  }

  /**
   * Primeiro operando.
   * 
   * @return operando.
   */
  public Exp getFirst() {
    return first;
  }

  /**
   * Operador.
   * 
   * @return operador.
   */
  public Symbol getOp() {
    return op;
  }

  /**
   * Segundo operando.
   * 
   * @return operando.
   */
  public Exp getSecond() {
    return second;
  }

  /** {@inheritDoc} */
  @Override
  public String toString() {
    String op = getOp().graphic;
    return String.format("%s %s %s", getFirst(), op, getSecond());
  }
}
