package tecgraf.javautils.jexpression.util;

import java.util.List;

import tecgraf.javautils.jexpression.JExpressionHandler;
import tecgraf.javautils.jexpression.exception.JExpressionException;

/**
 * Tratador que imprime a ordem das avaliaes de uma expresso.
 * 
 * NOTA: Esse tratador tem a nica finalidade de debug.
 * 
 * @author Tecgraf
 */
public class PrintHandler implements JExpressionHandler {

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleDouble(Double value) throws JExpressionException {
    String result = value.toString();
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handlePlus(Object first, Object second) {
    String result = String.format("%s + %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleMinus(Object first, Object second) {
    String result = String.format("%s - %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleTimes(Object first, Object second) {
    String result = String.format("%s * %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleDivision(Object first, Object second) {
    String result = String.format("%s / %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handlePow(Object first, Object second) {
    String result = String.format("%s^%s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleOr(Object first, Object second) {
    String result = String.format("%s || %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleAnd(Object first, Object second) {
    String result = String.format("%s && %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleEqual(Object first, Object second) {
    String result = String.format("%s == %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleNotEqual(Object first, Object second) {
    String result = String.format("%s != %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleGreater(Object first, Object second) {
    String result = String.format("%s > %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleGreaterEqual(Object first, Object second) {
    String result = String.format("%s >= %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleLower(Object first, Object second) {
    String result = String.format("%s < %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleLowerEqual(Object first, Object second) {
    String result = String.format("%s <= %s", first, second);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleQuestion(Object condition, Object then, Object otherwise) {
    String result = String.format("%s ? %s : %s", condition, then, otherwise);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleIndex(Object object, Object index) {
    String result = String.format("%s[%s]", object, index);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleUnaryMinus(Object object) {
    String result = String.format("-%s", object);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleNot(Object object) {
    String result = String.format("!%s", object);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleVar(String name) {
    System.out.println(name);
    return name;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleField(Object object, String field) {
    String result = String.format("%s.%s", object, field);
    System.out.println(result);
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object handleFunctionCall(String functionName, List<Object> params) {
    StringBuilder args = new StringBuilder();
    for (int i = 0; i < params.size(); i++) {
      args.append(params.get(i));
      if (i < params.size() - 1) {
        args.append(", ");
      }
    }
    String result = String.format("%s(%s)", functionName, args);
    System.out.println(result);
    return result;
  }
}
