package tecgraf.javautils.jexpression.parser.model;

/**
 * Classe que armazena a operao ternria de 'if-then-else'.
 * <p>
 * Exemplos:
 * <ul>
 * <li><tt>a ? b : c </tt>
 * <li><tt>a &lt; b ? a : b </tt>
 * </ul>
 *
 * @author Tecgraf
 */
public class Question extends Exp {

  /** Condio. */
  private Exp condition;

  /** Ao. */
  private Exp then;

  /** Caso contrrio. */
  private Exp otherwise;

  /**
   * Construtor.
   *
   * @param condition condio.
   * @param then ao.
   * @param otherwise caso contrrio.
   */
  public Question(Exp condition, Exp then, Exp otherwise) {
    if (condition == null) {
      throw new IllegalArgumentException("condition no pode ser nulo.");
    }
    if (then == null) {
      throw new IllegalArgumentException("then no pode ser nulo.");
    }
    if (otherwise == null) {
      throw new IllegalArgumentException("otherwise no pode ser nulo.");
    }
    this.condition = condition;
    this.then = then;
    this.otherwise = otherwise;
  }

  /**
   * Condio.
   *
   * @return condio.
   */
  public Exp getCondition() {
    return condition;
  }

  /**
   * Ao.
   *
   * @return ao.
   */
  public Exp getThen() {
    return then;
  }

  /**
   * Caso contrrio.
   *
   * @return caso contrrio.
   */
  public Exp getOtherwise() {
    return otherwise;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return String.format("%s ? %s : %s", condition, then, otherwise);
  }
}
