package tecgraf.javautils.parsers.exception;

import tecgraf.javautils.parsers.Session;
import tecgraf.javautils.parsers.State;
import tecgraf.javautils.parsers.symbols.Symbol;

/**
 * Representa uma exceo gerada quando no existe transio para um determinado
 * smbolo dentro de um estado.
 */
public final class NoTransitionException extends AutomatonException {
  /**
   * O smbolo que no possui transio definida.
   */
  private final Symbol<?> symbol;

  /**
   * O estado para o qual a transio no est definida.
   */
  private final State state;

  /**
   * Cria uma instncia com a sesso onde foi gerada a exceo, o smbolo para o
   * qual no existe transio e o estado de onde se tentou obter a transio.
   * 
   * @param session A sesso onde foi gerada a exceo.
   * @param symbol O smbolo para o qual no existe transio.
   * @param state O estado onde a exceo foi gerada.
   */
  public NoTransitionException(Session session, Symbol<?> symbol, State state) {
    super(session);
    this.symbol = symbol;
    this.state = state;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    String string = super.toString();
    final String syStr = symbol.toString();
    final String stStr = state.toString();
    return string + " - Smbolo: " + syStr + " - Estado: " + stStr;
  }
}
