package tecgraf.javautils.parsers.iterators;

import tecgraf.javautils.parsers.symbols.CharSymbol;

/**
 * Representa um iterador de smbolos de caracter (
 * {@link tecgraf.javautils.parsers.symbols.CharSymbol});
 */
public final class CharSymbolIterator implements SymbolIterator {
  /**
   * Os caracteres que sero iterados.
   */
  private final char[] charArray;

  /**
   * A posio atual.
   */
  private int currentPosition;

  /**
   * Cria um iterador de smbolos a partir dos caracteres recebidos.
   * 
   * @param charArray Um array de caracteres que sero iterados.
   */
  public CharSymbolIterator(char[] charArray) {
    this.charArray = charArray.clone();
    this.currentPosition = 0;
  }

  /**
   * Cria um iterador de smbolos a partir da String recebida. Cada caracter da
   * String ser um smbolo.
   * 
   * @param string A string com os caracteres que sero iterados.
   */
  public CharSymbolIterator(String string) {
    this(string.toCharArray());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean hasNext() {
    return (currentPosition < charArray.length);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public CharSymbol getNext() {
    if (this.hasNext()) {
      CharSymbol symbol = new CharSymbol(this.charArray[this.currentPosition]);
      this.currentPosition++;
      return symbol;
    }
    return null;
  }
}
