package tecgraf.javautils.parsers.symbols;

/**
 * Representa um caracter que ser usado como smbolo de um autmato finito (
 * {@link tecgraf.javautils.parsers.FiniteAutomaton}).
 */
public final class CharSymbol implements Symbol<Character> {
  /**
   * O objeto que representa o smbolo.
   */
  private final Character symbol;

  /**
   * Cria um smbolo a partir do caracter recebido.
   * 
   * @param symbol smbolo.
   */
  public CharSymbol(char symbol) {
    this.symbol = new Character(symbol);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (!this.getClass().equals(obj.getClass())) {
      return false;
    }
    CharSymbol other = (CharSymbol) obj;
    return this.symbol.equals(other.symbol);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return this.symbol.hashCode();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int compareTo(Symbol<Character> o) {
    return this.symbol.compareTo(o.getObject());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return this.symbol.toString();
  }

  /**
   * Obtm o objeto que o smbolo representa. O objeto ser sempre do tipo
   * {@link Character}.
   * 
   * @see tecgraf.javautils.parsers.symbols.Symbol#getObject()
   */
  @Override
  public Character getObject() {
    return this.symbol;
  }
}
