package tecgraf.javautils.pdfviewer.core.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;

import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerImages;

/**
 * Ao de zoom in.
 * 
 * @author Tecgraf
 */
public class PDFZoomInAction extends PDFAbstractDocumentOpenAwareAction {
  /**
   * Construtor.
   * 
   * @param pdfCorePanel painel bsico.
   */
  public PDFZoomInAction(PDFCorePanel pdfCorePanel) {
    super(pdfCorePanel, PDFViewerImages.createImageIcon("zoom.in.16.gif"));
    final KeyStroke ks = KeyStroke.getKeyStroke(KeyEvent.VK_ADD, 0);
    putValue(Action.ACCELERATOR_KEY, ks);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    getPDFCorePanel().setZoom(getPDFCorePanel().getZoom() + 7);
  }
}
