/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.pdfviewer.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.core.PDFCoreThumbnailPanel;
import tecgraf.javautils.pdfviewer.core.PDFDocument;
import tecgraf.javautils.pdfviewer.core.actions.PDFAbstractDocumentOpenAwareAction;
import tecgraf.javautils.pdfviewer.core.actions.PDFAbstractPageChangeAction;
import tecgraf.javautils.pdfviewer.core.actions.PDFFitHeightAction;
import tecgraf.javautils.pdfviewer.core.actions.PDFFitWholePageAction;
import tecgraf.javautils.pdfviewer.core.actions.PDFFitWidthAction;
import tecgraf.javautils.pdfviewer.core.actions.PDFNextPageAction;
import tecgraf.javautils.pdfviewer.core.actions.PDFPrevPageAction;
import tecgraf.javautils.pdfviewer.core.actions.PDFZoomInAction;
import tecgraf.javautils.pdfviewer.core.actions.PDFZoomOutAction;
import tecgraf.javautils.pdfviewer.core.listeners.PDFDocumentOpenCloseListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFPageChangedListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFZoomChangedListener;
import tecgraf.javautils.pdfviewer.core.listeners.PDFZoomFitPolicyChangedListener;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerBundle;
import tecgraf.javautils.pdfviewer.viewer.PageNumberPanel;
import tecgraf.javautils.pdfviewer.viewer.ZoomValueComboBox;
import tecgraf.javautils.pdfviewer.viewer.actions.PDFCloseAction;
import tecgraf.javautils.pdfviewer.viewer.actions.PDFShowThumbnailsAction;
import tecgraf.javautils.pdfviewer.viewer.listeners.PDFThumbnailsVisibilityListener;

public class PDFViewerPanel
extends JPanel {
    private final PDFCorePanel pdfCorePanel;
    private final PDFCoreThumbnailPanel coreThumbnailPanel = new PDFCoreThumbnailPanel();
    private final JToolBar pdfToolBar = new JToolBar();
    JSplitPane sideBarSplitPane = new JSplitPane();
    private final PDFAbstractDocumentOpenAwareAction fitWholePageAction;
    private final PDFAbstractDocumentOpenAwareAction fitWidthAction;
    private final PDFAbstractDocumentOpenAwareAction fitHeightAction;
    private final PDFAbstractDocumentOpenAwareAction zoomInAction;
    private final PDFAbstractDocumentOpenAwareAction zoomOutAction;
    private final PDFAbstractPageChangeAction prevPageAction;
    private final PDFAbstractPageChangeAction nextPageAction;
    private final PDFCloseAction pdfCloseAction;
    private final PDFShowThumbnailsAction showThumbnailsAction;
    private final PageNumberPanel pageNumberPanel;
    private final ButtonGroup fitButtonGroup = new ButtonGroup();
    private final ZoomValueComboBox zoomValueCombo = new ZoomValueComboBox();
    private final List<PDFThumbnailsVisibilityListener> thumbnailsVisibilityListeners = new ArrayList<PDFThumbnailsVisibilityListener>();
    boolean thumbnailsVisible = false;

    public PDFViewerPanel(Locale locale) {
        this(new PDFViewerBundle(locale));
    }

    public PDFViewerPanel(ResourceBundle bundle) {
        this.pdfCorePanel = new PDFCorePanel(bundle);
        this.fitWholePageAction = new PDFFitWholePageAction(this.pdfCorePanel);
        this.fitWidthAction = new PDFFitWidthAction(this.pdfCorePanel);
        this.fitHeightAction = new PDFFitHeightAction(this.pdfCorePanel);
        this.zoomInAction = new PDFZoomInAction(this.pdfCorePanel);
        this.zoomOutAction = new PDFZoomOutAction(this.pdfCorePanel);
        this.prevPageAction = new PDFPrevPageAction(this.pdfCorePanel);
        this.nextPageAction = new PDFNextPageAction(this.pdfCorePanel);
        this.pdfCloseAction = new PDFCloseAction(this.pdfCorePanel, this);
        this.showThumbnailsAction = new PDFShowThumbnailsAction(this.pdfCorePanel, this);
        this.setPreferredSize(new Dimension(600, 400));
        this.pageNumberPanel = new PageNumberPanel(this.pdfCorePanel);
        this.addListeners();
        this.addActionsTo(this.pdfToolBar);
        this.layout(this.pdfCorePanel, this.pdfToolBar, this.coreThumbnailPanel);
    }

    private void addListeners() {
        this.addPageChangeListener(this.nextPageAction);
        this.addPageChangeListener(this.prevPageAction);
        this.addPageChangeListener(this.pageNumberPanel);
        this.addPDFDocumentOpenCloseListener(this.pageNumberPanel);
        this.addPDFDocumentOpenCloseListener(this.prevPageAction);
        this.addPDFDocumentOpenCloseListener(this.nextPageAction);
        this.addPDFDocumentOpenCloseListener(this.zoomInAction);
        this.addPDFDocumentOpenCloseListener(this.zoomOutAction);
        this.addPDFDocumentOpenCloseListener(this.fitWholePageAction);
        this.addPDFDocumentOpenCloseListener(this.fitHeightAction);
        this.addPDFDocumentOpenCloseListener(this.fitWidthAction);
        this.addPDFZoomChangedListener(this.zoomValueCombo);
        this.addPDFDocumentOpenCloseListener(this.zoomValueCombo);
        this.addPDFDocumentOpenCloseListener(this.pdfCloseAction);
        this.addPDFDocumentOpenCloseListener(this.showThumbnailsAction);
        this.addPDFDocumentOpenCloseListener(this.coreThumbnailPanel);
        this.addPDFDocumentOpenCloseListener(new PDFDocumentOpenCloseListener(){

            @Override
            public void documentOpened(PDFCorePanel pdfCorePanel) {
                PDFViewerPanel.this.applyThumbsVisible();
            }

            @Override
            public void documentClosed(PDFCorePanel source) {
                PDFViewerPanel.this.hideThumbnails();
            }
        });
        this.addPageChangeListener(this.coreThumbnailPanel);
        this.coreThumbnailPanel.addPDFPageChangeRequestListener(this::setPage);
        this.zoomValueCombo.addPDFZoomChangeRequestedListener(this.pdfCorePanel::setZoom);
    }

    protected void addActionsTo(JToolBar toolBar) {
        toolBar.setFloatable(false);
        toolBar.add(this.getPrevPageAction());
        toolBar.add(this.getNextPageAction());
        toolBar.addSeparator();
        toolBar.add(this.pageNumberPanel);
        toolBar.addSeparator();
        toolBar.add(this.getZoomInAction());
        toolBar.add(this.getZoomOutAction());
        toolBar.add(this.zoomValueCombo);
        toolBar.addSeparator();
        final JToggleButton fitWholePageButton = new JToggleButton(this.getFitWholePageAction());
        final JToggleButton fitWidthButton = new JToggleButton(this.getFitWidthAction());
        final JToggleButton fitHeightButton = new JToggleButton(this.getFitHeightAction());
        this.fitButtonGroup.add(fitHeightButton);
        this.fitButtonGroup.add(fitWidthButton);
        this.fitButtonGroup.add(fitWholePageButton);
        this.pdfCorePanel.addPDFZoomFitPolicyChangedListener(new PDFZoomFitPolicyChangedListener(){

            @Override
            public void zoomFitPolicyChanged(PDFCorePanel.ZoomFitPolicy policy) {
                if (policy == PDFCorePanel.ZoomFitPolicy.FREE) {
                    PDFViewerPanel.this.fitButtonGroup.clearSelection();
                } else if (policy == PDFCorePanel.ZoomFitPolicy.WIDTH) {
                    fitWidthButton.setSelected(true);
                } else if (policy == PDFCorePanel.ZoomFitPolicy.HEIGHT) {
                    fitHeightButton.setSelected(true);
                } else if (policy == PDFCorePanel.ZoomFitPolicy.WHOLE_PAGE) {
                    fitWholePageButton.setSelected(true);
                }
            }
        });
        toolBar.add(fitWholePageButton);
        toolBar.add(fitWidthButton);
        toolBar.add(fitHeightButton);
        fitWholePageButton.setText(null);
        fitWidthButton.setText(null);
        fitHeightButton.setText(null);
        toolBar.addSeparator();
        JToggleButton showThumbnailsButton = new JToggleButton(this.showThumbnailsAction);
        showThumbnailsButton.setText(null);
        toolBar.add(showThumbnailsButton);
        this.addPDFThumbnailsVisibilityListeners(showThumbnailsButton::setSelected);
    }

    protected void layout(Component pageView, JToolBar pdfToolBar, Component thumbnailPanel) {
        this.setLayout(new BorderLayout());
        this.add((Component)pdfToolBar, "North");
    }

    public void loadDocument(PDFDocument document) {
        this.pdfCorePanel.loadDocument(document);
    }

    public Dimension getDocumentPageSize() {
        Dimension size = this.pdfCorePanel.getDocumentPageSize();
        return size;
    }

    protected void addPageChangeListener(PDFPageChangedListener listener) {
        this.pdfCorePanel.addPageChangeListener(listener);
    }

    public void addPDFDocumentOpenCloseListener(PDFDocumentOpenCloseListener listener) {
        this.pdfCorePanel.addPDFDocumentOpenCloseListener(listener);
    }

    public void addPDFThumbnailsVisibilityListeners(PDFThumbnailsVisibilityListener listener) {
        this.thumbnailsVisibilityListeners.add(listener);
    }

    public void setPage(int pageNumber) {
        this.pdfCorePanel.setPage(pageNumber);
    }

    public boolean canGoToNextPage() {
        return this.pdfCorePanel.canGoToNextPage();
    }

    public boolean canGoToPrevPage() {
        return this.pdfCorePanel.canGoToPrevPage();
    }

    public boolean goToNextPage() {
        return this.pdfCorePanel.goToNextPage();
    }

    public boolean goToPrevPage() {
        return this.pdfCorePanel.goToPrevPage();
    }

    public void setZoomFitPolicy(PDFCorePanel.ZoomFitPolicy fitPolicy) {
        this.pdfCorePanel.setZoomFitPolicy(fitPolicy);
    }

    public int getTotalPageNumber() {
        return this.pdfCorePanel.getTotalPageNumber();
    }

    public void closePDF() {
        if (this.pdfCorePanel.hasOpenFile()) {
            this.pdfCorePanel.closePDF();
        }
    }

    public Action getFitWidthAction() {
        return this.fitWidthAction;
    }

    public Action getFitHeightAction() {
        return this.fitHeightAction;
    }

    public Action getFitWholePageAction() {
        return this.fitWholePageAction;
    }

    public Action getZoomInAction() {
        return this.zoomInAction;
    }

    public Action getZoomOutAction() {
        return this.zoomOutAction;
    }

    public Action getPrevPageAction() {
        return this.prevPageAction;
    }

    public Action getNextPageAction() {
        return this.nextPageAction;
    }

    public Action getPDFCloseAction() {
        return this.pdfCloseAction;
    }

    public Action getPDFShowThumbnailsAction() {
        return this.showThumbnailsAction;
    }

    public JToolBar getPDFToolBar() {
        return this.pdfToolBar;
    }

    public void addPDFZoomChangedListener(PDFZoomChangedListener listener) {
        this.pdfCorePanel.addPDFZoomChangedListener(listener);
    }

    public void addPDFZoomFitPolicyChangedListener(PDFZoomFitPolicyChangedListener listener) {
        this.pdfCorePanel.addPDFZoomFitPolicyChangedListener(listener);
    }

    protected void showThumbnails() {
        this.remove(this.pdfCorePanel);
        this.sideBarSplitPane.setLeftComponent(this.coreThumbnailPanel);
        this.sideBarSplitPane.setRightComponent(this.pdfCorePanel);
        this.sideBarSplitPane.resetToPreferredSizes();
        this.add((Component)this.sideBarSplitPane, "Center");
        this.revalidate();
    }

    protected void hideThumbnails() {
        this.remove(this.sideBarSplitPane);
        this.add((Component)this.pdfCorePanel, "Center");
        this.revalidate();
    }

    public void setThumbnailsVisible(boolean visible) {
        if (visible != this.thumbnailsVisible) {
            this.thumbnailsVisible = visible;
            this.applyThumbsVisible();
            this.notifyThumbnailsSidebarVisibilityListeners(this.thumbnailsVisible);
        }
    }

    private void notifyThumbnailsSidebarVisibilityListeners(boolean thumbnailsVisible) {
        for (PDFThumbnailsVisibilityListener listener : this.thumbnailsVisibilityListeners) {
            listener.onThumbnailsVisibilityChanged(thumbnailsVisible);
        }
    }

    public boolean isThumbnailsVisible() {
        return this.thumbnailsVisible;
    }

    protected void applyThumbsVisible() {
        if (this.thumbnailsVisible) {
            this.showThumbnails();
        } else {
            this.hideThumbnails();
        }
    }

    public String getString(String key) {
        return this.pdfCorePanel.getString(key);
    }
}

