/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.demo;

import tecgraf.javautils.sparkserver.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.core.JuIFunction;
import tecgraf.javautils.sparkserver.demo.RootControllerDate;
import tecgraf.javautils.sparkserver.demo.RootControllerOutput;
import tecgraf.javautils.sparkserver.exceptions.JuBadRequestException;
import tecgraf.javautils.sparkserver.standard.JuController;
import tecgraf.javautils.sparkserver.standard.JuEndpoint;
import tecgraf.javautils.sparkserver.standard.JuRoute;
import tecgraf.javautils.sparkserver.standard.JuVerb;
import tecgraf.javautils.sparkserver.utils.JuRequestUtilities;
import tecgraf.javautils.sparkserver.utils.JuResponseUtilities;
import tecgraf.javautils.sparkserver.utils.JuStringUtilities;

public class RootController
extends JuController {
    protected RootController() {
        this.addEndpoint(this.getDateEndpoint());
        this.addEndpoint(this.getEchoEndpoint());
        this.setName("Root");
        this.setDescription("Controlador root com exemplos");
    }

    private JuIEndpoint getDateEndpoint() {
        JuIFunction<RootControllerDate> function = (req, res) -> {
            String _day = JuRequestUtilities.getRequestParameter(req, "day", true);
            String _month = JuRequestUtilities.getRequestParameter(req, "month", true);
            String _year = JuRequestUtilities.getRequestParameter(req, "year", true);
            if (_day == null || _month == null || _year == null) {
                throw new JuBadRequestException("not enough parameters!");
            }
            Long day = JuStringUtilities.longOrNull(_day);
            Long month = JuStringUtilities.longOrNull(_month);
            Long year = JuStringUtilities.longOrNull(_year);
            if (day == null || month == null || year == null) {
                throw new JuBadRequestException("not valid parameters!");
            }
            int d = day.intValue();
            int m = month.intValue();
            int y = year.intValue();
            RootControllerDate date = new RootControllerDate(d, m, y);
            return JuResponseUtilities.setResponseAsJsonObject(res, 200, date);
        };
        JuRoute<RootControllerDate> route = new JuRoute<RootControllerDate>(function, RootControllerDate.class);
        JuEndpoint endpoint = new JuEndpoint(JuVerb.GET, "date/:day/:month/:year", route);
        endpoint.setName("date").setDescription("Returns a structure data base on path parameters");
        endpoint.addPathParameter("day").setDescription("day of year").setExampleAsString("31").setClassValue(Integer.class);
        endpoint.addPathParameter("month").setDescription("month of year").setExampleAsString("31").setClassValue(Integer.class);
        endpoint.addPathParameter("year").setDescription("year").setExampleAsString("1970").setClassValue(Integer.class);
        return endpoint;
    }

    private JuIEndpoint getEchoEndpoint() {
        JuIFunction<RootControllerOutput> function = (req, res) -> {
            String input = JuRequestUtilities.getQueryParameter(req, "input", false);
            input = input == null ? "no-input" : input;
            RootControllerOutput output = new RootControllerOutput(input);
            return JuResponseUtilities.setResponseAsJsonObject(res, 200, output);
        };
        JuRoute<RootControllerOutput> route = new JuRoute<RootControllerOutput>(function, RootControllerOutput.class);
        JuEndpoint endpoint = new JuEndpoint(JuVerb.GET, "echo", route);
        endpoint.setName("echo").setDescription("Returns echo string based on query parameter");
        endpoint.addQueryParameter("input").setRequired(false).setClassValue(String.class).setDescription("Input").setExampleAsString("yada yada");
        return endpoint;
    }
}

