/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.utils;

import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import tecgraf.javautils.sparkserver.core.JuIController;
import tecgraf.javautils.sparkserver.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.core.JuIPathParameter;
import tecgraf.javautils.sparkserver.core.JuIQueryParameter;
import tecgraf.javautils.sparkserver.standard.JuServer;
import tecgraf.javautils.sparkserver.utils.JuStringUtilities;

public class JuSwaggerReader {
    private final JuServer server;
    private final Swagger swagger;

    public JuSwaggerReader(JuServer server) {
        this.server = server;
        this.swagger = new Swagger();
    }

    public Swagger read() {
        Info info = this.findInfo();
        this.swagger.setInfo(info);
        this.swagger.setHost(this.server.getHostAddress() + ":" + this.server.getHostPort());
        this.swagger.setSchemes(Collections.singletonList(Scheme.HTTP));
        this.server.getControllers().forEach(ctrl -> this.read((JuIController)ctrl));
        return this.swagger;
    }

    private void read(JuIController controller) {
        controller.getEndpoints().forEach(ep -> {
            Tag tag = new Tag();
            tag.name(controller.getName());
            tag.description(controller.getDescription());
            this.swagger.tag(tag);
            this.read(controller, (JuIEndpoint)ep);
        });
    }

    private void read(JuIController controller, JuIEndpoint endpoint) {
        Path path = new Path();
        Operation op = new Operation();
        op.description(endpoint.getDescription());
        op.setTags(Collections.singletonList(controller.getName()));
        List<String> consumes = this.findResponseConsume(endpoint);
        op.consumes(consumes);
        List<String> produces = this.findResponseProduce(endpoint);
        op.produces(produces);
        Set<JuIPathParameter> pps = endpoint.getPathParameters();
        pps.forEach(pp -> {
            PathParameter parameter = new PathParameter();
            parameter.setName(pp.getName());
            parameter.setDescription(pp.getDescription());
            parameter.setExample(pp.getExampleAsString());
            parameter.setType(pp.getClassValue().getSimpleName().toLowerCase());
            op.addParameter((Parameter)parameter);
        });
        Set<JuIQueryParameter> qps = endpoint.getQueryParameters();
        qps.forEach(qp -> {
            QueryParameter parameter = new QueryParameter();
            parameter.setName(qp.getName());
            parameter.setDescription(qp.getDescription());
            parameter.setExample(qp.getExampleAsString());
            parameter.setType(qp.getClassValue().getSimpleName().toLowerCase());
            op.addParameter((Parameter)parameter);
        });
        Response response = new Response();
        response.description("ok");
        RefModel model = new RefModel();
        model.set$ref("abc");
        model.setDescription("yyy");
        response.setResponseSchema((Model)model);
        op.response(200, response);
        op.setSchemes(Collections.singletonList(Scheme.HTTP));
        path.set(this.findOperationName(endpoint), op);
        String fullPath = this.findFullPath(controller, endpoint);
        this.swagger.path(fullPath, path);
    }

    private List<String> findResponseProduce(JuIEndpoint endpoint) {
        Class responseClass = endpoint.getRoute().getResponseClass();
        List<String> consumes = responseClass.equals(String.class) ? Collections.singletonList("text/plain") : Collections.singletonList("application/json");
        return consumes;
    }

    private List<String> findResponseConsume(JuIEndpoint endpoint) {
        Class responseClass = endpoint.getRoute().getResponseClass();
        List<String> consumes = responseClass.equals(String.class) ? Collections.singletonList("text/plain") : Collections.singletonList("application/json");
        return consumes;
    }

    private Info findInfo() {
        Contact contact = new Contact();
        contact.setName(this.server.getContactName());
        Info info = new Info();
        info.contact(contact);
        info.description(this.server.getDescription());
        info.setTitle(this.server.getName());
        info.setVersion(this.server.getVersion());
        return info;
    }

    private String findFullPath(JuIController controller, JuIEndpoint endpoint) {
        Object pth = "/" + JuStringUtilities.getRealPath(controller, endpoint.getPath());
        pth = ((String)pth).replaceAll(":(\\w+)", "{$1}");
        return pth;
    }

    private String findOperationName(JuIEndpoint endpoint) {
        return endpoint.getVerb().name().toLowerCase();
    }
}

