package tecgraf.javautils.version;

/**
 * Modela um par de verses para eventual migrao {@code "de/para"}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class VersionNumberTransition {

  /** Verso inicial. */
  private final VersionNumber fromVersion;

  /** Verso final. */
  private final VersionNumber toVersion;

  /**
   * Construtor.
   * 
   * @param fromVersion verso inicial.
   * @param toVersion verso final.
   */
  public VersionNumberTransition(VersionNumber fromVersion,
    VersionNumber toVersion) {
    this.fromVersion = fromVersion;
    this.toVersion = toVersion;

    boolean isOnError = fromVersion.compareTo(toVersion) >= 0;
    if (isOnError) {
      String err = String.format("Bad transition formed: %s", this);
      throw new IllegalArgumentException(err);
    }
  }

  /**
   * Verso inicial.
   * 
   * @return valor
   */
  public VersionNumber getFromVersion() {
    return fromVersion;
  }

  /**
   * Verso final.
   * 
   * @return valor
   */
  public VersionNumber getToVersion() {
    return toVersion;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    String fromTxt = fromVersion.toString();
    String toTxt = toVersion.toString();
    return String.format("[%s -> %s]", fromTxt, toTxt);
  }
}
