package tecgraf.javautils.version;

import java.util.ArrayList;
import java.util.List;

/**
 * Utilit�rio para ajuda de controle entre vers�es.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class VersionUtils {

  /** N�mero m�ximo permitido de transi��es (por seguran�a). */
  public static final int MAX_VERSION_LIST = 500;

  /**
   * Retorna a lista de vers�es existentes do recurso entre duas vers�es.
   * 
   * @param finder objeto de busca do recurso em uma vers�o.
   * @param fromVersion vers�o inicial
   * @param toVersion vers�o final
   * @return lista
   */
  static public List<VersionNumber> getExistantVersionsList(
    VersionNumberFinder finder, VersionNumber fromVersion,
    VersionNumber toVersion) {
    List<VersionNumber> list = new ArrayList<>();
    VersionNumber version = fromVersion.clone();
    while (version.isValid()) {
      boolean toVersionReached = (version.compareTo(toVersion) > 0);
      if (toVersionReached) {
        break;
      }
      boolean isPresent = finder.hasVersionNumber(version);
      if (isPresent) {
        if (list.size() > MAX_VERSION_LIST) {
          String fmt = "Max of versions (%d) transitions reached for %s!";
          String err = String.format(fmt, MAX_VERSION_LIST, version);
          throw new IllegalStateException(err);
        }
        VersionNumber newVersion = version.clone();
        newVersion.freeze();
        list.add(newVersion);
      }
      version.add();
    }
    return list;
  }

  /**
   * Monta uma lista de transi��es de vers�es.
   * 
   * @param versionsList lista de vers�es
   * @return lista de transi��es
   */
  static public List<VersionNumberTransition> getTransitionPairsList(
    List<VersionNumber> versionsList) {
    List<VersionNumberTransition> list =
            new ArrayList<>();
    if (versionsList == null) {
      return list;
    }
    int size = versionsList.size();
    if (size < 2) {
      return list;
    }

    for (int i = 0; i < size - 1; i++) {
      VersionNumber fromVersion = versionsList.get(i);
      VersionNumber toVersion = versionsList.get(i + 1);
      VersionNumberTransition pair =
        new VersionNumberTransition(fromVersion, toVersion);
      list.add(pair);
    }
    return list;
  }
}
