/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.version;

import java.util.ArrayList;
import java.util.List;
import tecgraf.javautils.version.VersionNumber;
import tecgraf.javautils.version.VersionNumberFinder;
import tecgraf.javautils.version.VersionNumberTransition;

public class VersionUtils {
    public static final int MAX_VERSION_LIST = 500;

    public static List<VersionNumber> getExistantVersionsList(VersionNumberFinder finder, VersionNumber fromVersion, VersionNumber toVersion) {
        ArrayList<VersionNumber> list = new ArrayList<VersionNumber>();
        VersionNumber version = fromVersion.clone();
        while (version.isValid()) {
            boolean toVersionReached;
            boolean bl = toVersionReached = version.compareTo(toVersion) > 0;
            if (toVersionReached) break;
            boolean isPresent = finder.hasVersionNumber(version);
            if (isPresent) {
                if (list.size() > 500) {
                    String fmt = "Max of versions (%d) transitions reached for %s!";
                    String err = String.format(fmt, 500, version);
                    throw new IllegalStateException(err);
                }
                VersionNumber newVersion = version.clone();
                newVersion.freeze();
                list.add(newVersion);
            }
            version.add();
        }
        return list;
    }

    public static List<VersionNumberTransition> getTransitionPairsList(List<VersionNumber> versionsList) {
        ArrayList<VersionNumberTransition> list = new ArrayList<VersionNumberTransition>();
        if (versionsList == null) {
            return list;
        }
        int size = versionsList.size();
        if (size < 2) {
            return list;
        }
        for (int i = 0; i < size - 1; ++i) {
            VersionNumber fromVersion = versionsList.get(i);
            VersionNumber toVersion = versionsList.get(i + 1);
            VersionNumberTransition pair = new VersionNumberTransition(fromVersion, toVersion);
            list.add(pair);
        }
        return list;
    }
}

