/*
 * $Id: XMLAttribute.java 1927 2005-08-25 23:34:25 +0000 (Thu, 25 Aug 2005)
 * costa $
 */

package tecgraf.javautils.xml;

/**
 * Atributos (nome + valor). Esta estrutura  usada pelas listas de atributos
 * dos elementos XML.
 */
public class XMLAttribute {

  /** Nome */
  final private String name;

  /** Valor */
  final private String value;

  /**
   * Construtor.
   * 
   * @param name nome
   * @param value valor
   */
  public XMLAttribute(final String name, final String value) {
    this.name = name;
    this.value = value;
  }

  /**
   * @return o nome do atributo
   */
  public String getName() {
    return name;
  }

  /**
   * @return o valor do atributo (como string)
   */
  public String getValue() {
    return value;
  }
}
