/* $Id: XMLComment.java 67804 2007-09-20 16:31:21Z costa $ */

package tecgraf.javautils.xml;

import java.io.IOException;
import java.io.Writer;

/**
 * Comentrios XML. Esta classe nunca  instanciada pelo handler, pois no h
 * evento (pelo menos no JAXP 1.1) associado a comentrios, mas pode ser
 * instanciada a partir da aplicao. O texto do comentrio deve ser associado
 * ao valor do elemento.
 * 
 * @author Andre Oliveira da Costa
 */
public class XMLComment extends XMLNullDataElement {

  /**
   * Escreve o comentrio, com a identao corrente. O comentrio ser escrito
   * em uma nica linha.
   * 
   * @param stream stream de sada
   * @param ident identao
   * 
   * @throws IOException se houver problemas na escrita
   */
  @Override
  public void write(final Writer stream, final String ident) throws IOException {
    write(stream, ident, getStrValue());
  }

  /**
   * Escreve o comentrio, com a identao corrente. O comentrio ser escrito
   * em uma nica linha.
   * 
   * @param stream stream de sada
   * @param ident identao
   * @param text texto do comentrio
   * @throws IOException se houver problemas na escrita
   */
  public static void write(final Writer stream, final String ident,
    final String text) throws IOException {
    stream.write(ident + "<!-- " + text + " -->\n");
  }

  /**
   * Comentrios so criados apenas a partir da aplicao -- SAX no gera
   * eventos para comentrios. Este construtor no recebe a tag, a exemplo dos
   * demais elementos, mas sim o valor (texto) do comentrio.
   * 
   * @param text texto associado ao comentrio
   */
  public XMLComment(final String text) {
    super();
    setValue(text);
  }

}
