/* $Id: XMLEmptyElement.java 67804 2007-09-20 16:31:21Z costa $ */

package tecgraf.javautils.xml;

import java.io.IOException;
import java.io.Writer;

/**
 * Elemento XML vazio (&lt;tag attr1="val1" attr2="val2" ... /&gt;).
 * 
 * @author Andre Oliveira da Costa
 */
public class XMLEmptyElement extends XMLNullDataElement {

  /**
   * (No) escreve a tag de fechamento.
   * 
   * @param stream <i>stream</i> de saida.
   * @param ident identao
   */
  @Override
  final public void writeEndTag(final Writer stream, final String ident)
    throws IOException {
    /* vazio */
  }

  /**
   * Escreve a tag de abertura, no formato compatvel com elementos vazios.
   * 
   * @param stream <i>stream</i> de saida.
   * @param ident identao
   */
  @Override
  final public void writeStartTag(final Writer stream, final String ident)
    throws IOException {
    stream.write(ident + "<" + getTag());
    writeAttributes(stream);
    stream.write("/>");
  }

  /**
   * Escreve a tag de abertura, no formato compatvel com elementos vazios, e
   * adiciona um fim-de-linha.
   * 
   * @param stream <i>stream</i> de saida.
   * @param ident identao
   */
  @Override
  final public void writeStartTagln(final Writer stream, final String ident)
    throws IOException {
    writeStartTag(stream, ident);
    stream.write("\n");
  }

  /**
   * Retorno do texto interno.
   * 
   * @see tecgraf.javautils.xml.XMLElementInterface#getStrValue()
   */
  @Override
  final public String getStrValue() {
    return "";
  }

  /**
   * Escreve o elemento corrente (o que significa, no caso de elementos vazios,
   * escrever apenas a tag de abertura).
   * 
   * @param stream <i>stream</i> de saida.
   */
  @Override
  public void write(final Writer stream, final String ident) throws IOException {
    writeStartTagln(stream, ident);
  }

}
