/* $Id: XMLRootElement.java 117377 2011-04-18 18:22:48Z clinio $ */

package tecgraf.javautils.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

/**
 * Implementao bsica de um elemento XML para ser associado  tag-raiz do
 * documento. Este elemento apenas armazena a lista com os seus filhos para
 * futura referncia.
 * 
 * @author Andre Oliveira da Costa
 */
public class XMLRootElement extends XMLBasicElement {

  /**
   * Lista com os filhos do elemento.
   */
  private List<XMLElementInterface> children;

  /**
   * Callback de fechamento do elemento. Apenas armazena a lista de filhos para
   * futura referncia.
   * 
   * @param childrenList lista com os filhos do elemento
   */
  @Override
  public void endTag(final List<XMLElementInterface> childrenList) {
    this.children = childrenList;
  }

  /**
   * Escreve o elemento, com seus filhos.
   * 
   * @param stream stream de sada
   * @param ident identao
   * @throws IOException se houve algum erro de I/O na escrita
   */
  @Override
  public void write(final Writer stream, final String ident) throws IOException {
    final String newIdent = XMLBasicElement.getNextIdentation(ident);
    writeStartTagln(stream, ident);
    for (final XMLElementInterface elem : children) {
      elem.write(stream, newIdent);
    }
    writeEndTag(stream, ident);
  }

  /**
   * Construtor.
   */
  public XMLRootElement() {
    super();
  }
}
