/**
 * $Id: XMLUtils.java 116910 2011-04-04 13:32:22Z clinio $
 */
package tecgraf.javautils.xml;

import java.io.Closeable;
import java.io.IOException;

/**
 * Coleo de mtodos utilitrios.
 */
public class XMLUtils {
  /**
   * "Consertamos" uma URL: se ela no comea com o prefixo especificado na
   * construo da fbrica, fazemos com que comece. P.ex. se o prefixo deve ser
   * "http://tissot/marlim/", a URL file:///local/costa/marlim/marlim.dtd 
   * substituda por http://tissot/marlim/marlim.dtd
   * 
   * @param url - URL a ser corrigida
   * @param dtdPrefix - prefixo do DTD
   * @return URL com o prefixo correto
   */
  public static String fixUrlPrefix(String url, String dtdPrefix) {
    // No h prefixo... Nada a fazer!
    if (dtdPrefix == null) {
      return url;
    }

    // se a URL j est com o prefixo correto, no h mais nada a fazer
    if (url.startsWith(dtdPrefix)) {
      return url;
    }
    /*
     * se a URL no comea com o protocolo assumimos que se trata de uma URL
     * relativa, e simplesmente acrescentamos o prefixo
     */
    if (url.matches("^(file:/|http:).*") == false) {
      return dtdPrefix + url;
    }
    // seno, trocamos tudo menos o final (nome do DTD) pelo prefixo correto
    return url.replaceFirst("(file:/|http:)//.*/(.*)$", dtdPrefix + "$2");
  }

  /**
   * Fecha um {@link Closeable} em blocos <code>finally</code>).
   * 
   * @param closeable objeto a ser fechado.
   */
  static void close(Closeable closeable) {
    if (closeable != null) {
      try {
        closeable.close();
      }
      catch (IOException e) {
        //faz nada
      }
    }
  }
}
