package tecgraf.javautils.xml.conversion;

import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

/**
 * A classe <code>ConversionDocument</code>  uma fachada para um documento DOM.
 * Ela existe apenas para permitir que a informao do DTD associado ao
 * documento possa ser atualizada, j que esta informao  <i>read-only</i>.
 * 
 * @see Document
 */
public class ConversionDocument implements Document {
  /**
   * Representao DOM para o documento.
   */
  private Document document;
  /**
   * DTD associado ao documento.
   */
  private String dtd;

  /**
   * Instancia um objeto.
   * 
   * @param doc - documento DOM
   */
  public ConversionDocument(Document doc) {
    if (doc == null) {
      throw new IllegalArgumentException("Documento no pode ser nulo");
    }
    this.document = doc;
    DocumentType docType = doc.getDoctype();
    // se o documento no tiver a declarao DOCTYPE, docType ser null
    this.dtd = docType == null ? null : docType.getSystemId();
  }

  /**
   * Retorna o DTD associado ao documento. O DTD  atualizado  medida que as
   * converses vo sendo aplicadas ao documento.
   * 
   * @return DTD associado ao documento
   */
  public String getDTD() {
    return dtd;
  }

  /**
   * Atualiza o DTD associado ao documento. OBS.: no  atualizado realmente no
   * {@link Document}, pois neste esse dado  <i>read-only</i>.
   * 
   * @param dtd - DTD
   * @see XMLConversionInterface#convert()
   */
  public void setDTD(String dtd) {
    this.dtd = dtd;
  }

  /**
   * Obtm o documento DOM.
   * 
   * @return documento DOM
   */
  public Document getDOMDocument() {
    return document;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node adoptNode(Node source) throws DOMException {
    return document.adoptNode(source);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node appendChild(Node newChild) throws DOMException {
    return document.appendChild(newChild);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node cloneNode(boolean deep) {
    return document.cloneNode(deep);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public short compareDocumentPosition(Node other) throws DOMException {
    return document.compareDocumentPosition(other);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Attr createAttribute(String name) throws DOMException {
    return document.createAttribute(name);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Attr createAttributeNS(String namespaceURI, String qualifiedName)
    throws DOMException {
    return document.createAttributeNS(namespaceURI, qualifiedName);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public CDATASection createCDATASection(String data) throws DOMException {
    return document.createCDATASection(data);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Comment createComment(String data) {
    return document.createComment(data);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DocumentFragment createDocumentFragment() {
    return document.createDocumentFragment();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Element createElement(String tagName) throws DOMException {
    return document.createElement(tagName);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Element createElementNS(String namespaceURI, String qualifiedName)
    throws DOMException {
    return document.createElementNS(namespaceURI, qualifiedName);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public EntityReference createEntityReference(String name) throws DOMException {
    return document.createEntityReference(name);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ProcessingInstruction createProcessingInstruction(String target,
    String data) throws DOMException {
    return document.createProcessingInstruction(target, data);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Text createTextNode(String data) {
    return document.createTextNode(data);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public NamedNodeMap getAttributes() {
    return document.getAttributes();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getBaseURI() {
    return document.getBaseURI();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public NodeList getChildNodes() {
    return document.getChildNodes();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DocumentType getDoctype() {
    return document.getDoctype();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Element getDocumentElement() {
    return document.getDocumentElement();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getDocumentURI() {
    return document.getDocumentURI();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DOMConfiguration getDomConfig() {
    return document.getDomConfig();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Element getElementById(String elementId) {
    return document.getElementById(elementId);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public NodeList getElementsByTagName(String tagname) {
    return document.getElementsByTagName(tagname);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
    return document.getElementsByTagNameNS(namespaceURI, localName);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getFeature(String feature, String version) {
    return document.getFeature(feature, version);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node getFirstChild() {
    return document.getFirstChild();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DOMImplementation getImplementation() {
    return document.getImplementation();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getInputEncoding() {
    return document.getInputEncoding();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node getLastChild() {
    return document.getLastChild();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getLocalName() {
    return document.getLocalName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getNamespaceURI() {
    return document.getNamespaceURI();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node getNextSibling() {
    return document.getNextSibling();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getNodeName() {
    return document.getNodeName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public short getNodeType() {
    return document.getNodeType();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getNodeValue() throws DOMException {
    return document.getNodeValue();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Document getOwnerDocument() {
    return document.getOwnerDocument();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node getParentNode() {
    return document.getParentNode();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getPrefix() {
    return document.getPrefix();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node getPreviousSibling() {
    return document.getPreviousSibling();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean getStrictErrorChecking() {
    return document.getStrictErrorChecking();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getTextContent() throws DOMException {
    return document.getTextContent();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getUserData(String key) {
    return document.getUserData(key);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getXmlEncoding() {
    return document.getXmlEncoding();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean getXmlStandalone() {
    return document.getXmlStandalone();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getXmlVersion() {
    return document.getXmlVersion();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean hasAttributes() {
    return document.hasAttributes();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean hasChildNodes() {
    return document.hasChildNodes();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node importNode(Node importedNode, boolean deep) throws DOMException {
    return document.importNode(importedNode, deep);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node insertBefore(Node newChild, Node refChild) throws DOMException {
    return document.insertBefore(newChild, refChild);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isDefaultNamespace(String namespaceURI) {
    return document.isDefaultNamespace(namespaceURI);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isEqualNode(Node arg) {
    return document.isEqualNode(arg);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isSameNode(Node other) {
    return document.isSameNode(other);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isSupported(String feature, String version) {
    return document.isSupported(feature, version);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String lookupNamespaceURI(String prefix) {
    return document.lookupNamespaceURI(prefix);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String lookupPrefix(String namespaceURI) {
    return document.lookupPrefix(namespaceURI);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void normalize() {
    document.normalize();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void normalizeDocument() {
    document.normalizeDocument();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node removeChild(Node oldChild) throws DOMException {
    return document.removeChild(oldChild);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node renameNode(Node n, String namespaceURI, String qualifiedName)
    throws DOMException {
    return document.renameNode(n, namespaceURI, qualifiedName);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
    return document.replaceChild(newChild, oldChild);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setDocumentURI(String documentURI) {
    document.setDocumentURI(documentURI);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setNodeValue(String nodeValue) throws DOMException {
    document.setNodeValue(nodeValue);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setPrefix(String prefix) throws DOMException {
    document.setPrefix(prefix);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setStrictErrorChecking(boolean strictErrorChecking) {
    document.setStrictErrorChecking(strictErrorChecking);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setTextContent(String textContent) throws DOMException {
    document.setTextContent(textContent);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object setUserData(String key, Object data, UserDataHandler handler) {
    return document.setUserData(key, data, handler);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    document.setXmlStandalone(xmlStandalone);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setXmlVersion(String xmlVersion) throws DOMException {
    document.setXmlVersion(xmlVersion);
  }
}
