/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jacorb.config.Configuration;
import org.jacorb.imr.Admin;
import org.jacorb.imr.AdminHelper;
import org.jacorb.imr.AdminPackage.DuplicateServerName;
import org.jacorb.imr.AdminPackage.FileOpFailed;
import org.jacorb.imr.AdminPackage.IllegalServerName;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.Registration;
import org.jacorb.imr.RegistrationHelper;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.ServerStartupDaemon;
import org.jacorb.imr.ServerStartupDaemonHelper;
import org.jacorb.imr.util.ImRPOATableModel;
import org.jacorb.imr.util.ImRServerTableModel;
import org.jacorb.orb.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.UserException;
import org.slf4j.Logger;

public class ImRModel {
    private Admin m_admin;
    private ORB m_orb = (ORB)org.omg.CORBA.ORB.init(new String[0], null);
    private Configuration configuration = this.m_orb.getConfiguration();
    private Logger logger = this.configuration.getLogger("org.jacorb.imr.model");
    private ServerInfo[] m_servers;
    private ImRInfo m_imr_info;
    private DefaultMutableTreeNode m_top_node;
    private JTree m_tree;
    private DefaultTreeModel m_tree_model;
    private ImRPOATableModel m_poa_model;
    private ImRServerTableModel m_server_model;
    private Hashtable m_server_names;
    private JComboBox m_host_selector;
    private DefaultComboBoxModel m_host_selector_model;
    private Hashtable m_host_names;
    private RefreshThread m_refresh_thread;
    protected int m_current_refresh_interval = 20000;
    protected boolean m_refresh_disabled = false;
    private Vector m_server_nodes;
    private Vector m_poa_nodes;

    public ImRModel() {
        try {
            this.m_admin = AdminHelper.narrow(this.m_orb.resolve_initial_references("ImplementationRepository"));
        }
        catch (InvalidName in) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Could not contact Impl. Repository!");
            }
            return;
        }
        this.fetchImRInfo();
        this.m_top_node = new DefaultMutableTreeNode(this.m_imr_info);
        this.m_tree_model = new DefaultTreeModel(this.m_top_node, false);
        this.m_tree = new JTree(this.m_tree_model);
        this.m_server_model = new ImRServerTableModel(this);
        this.m_poa_model = new ImRPOATableModel();
        this.m_server_names = new Hashtable();
        this.m_server_nodes = new Vector();
        this.m_poa_nodes = new Vector();
        this.m_host_names = new Hashtable();
        this.m_host_selector_model = new DefaultComboBoxModel();
        this.m_host_selector = new JComboBox(this.m_host_selector_model);
        this.m_host_selector.setEditable(true);
        this.fetchServers();
        this.m_tree.expandRow(0);
        this.m_refresh_thread = new RefreshThread(this.m_current_refresh_interval);
    }

    public void connectTo(String ior_url) {
        try {
            this.m_admin = AdminHelper.narrow(this.m_orb.resolve_initial_references("ImplementationRepository"));
        }
        catch (InvalidName in) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Could not contact Impl. Repository!");
            }
            return;
        }
        this.fetchImRInfo();
        this.m_top_node.setUserObject(this.m_imr_info);
        this.fetchServers();
        this.setRefreshInterval(this.m_current_refresh_interval);
    }

    public JComboBox getHostSelector() {
        return this.m_host_selector;
    }

    public TableModel getPOATableModel() {
        return this.m_poa_model;
    }

    public TableModel getServerTableModel() {
        return this.m_server_model;
    }

    public void poaTableForServer(ServerInfo server) {
        this.m_poa_model.setPOAs(server.poas);
    }

    public void fetchServers() {
        this.m_servers = this.m_admin.list_servers();
        this.m_server_model.setServers(this.m_servers);
        this.m_server_names.clear();
        for (int _i = 0; _i < this.m_servers.length; ++_i) {
            this.m_server_names.put(this.m_servers[_i].name, new Integer(_i));
        }
        String _server = this.m_poa_model.getServerName();
        if (_server != null) {
            this.m_poa_model.setPOAs(this.m_servers[this.indexForServerName((String)_server)].poas);
        }
        this.buildTree();
        this.buildHostSelectorModel();
    }

    public void removeServer(String name) {
        this.removeServer(this.indexForServerName(name));
    }

    public void removeServer(int server_row) {
        try {
            this.m_admin.unregister_server(this.m_servers[server_row].name);
        }
        catch (Exception _e) {
            this.handleException(_e);
        }
        this.fetchServers();
    }

    public void holdServer(String name) {
        this.holdServer(this.indexForServerName(name));
    }

    public void holdServer(int server_row) {
        try {
            this.m_admin.hold_server(this.m_servers[server_row].name);
        }
        catch (Exception _e) {
            this.handleException(_e);
        }
        this.refreshServer(server_row);
    }

    public void releaseServer(String name) {
        this.releaseServer(this.indexForServerName(name));
    }

    public void releaseServer(int server_row) {
        try {
            this.m_admin.release_server(this.m_servers[server_row].name);
        }
        catch (Exception _e) {
            this.handleException(_e);
        }
        this.refreshServer(server_row);
    }

    public void refreshServer(String name) {
        this.refreshServer(this.indexForServerName(name));
    }

    public void refreshServer(int index) {
        try {
            ServerInfo _server;
            this.m_servers[index] = _server = this.m_admin.get_server_info(this.m_servers[index].name);
            this.buildServerNode(index);
            this.m_server_model.serverRefreshed(index);
            if (this.m_host_names.put(this.m_servers[index].host, this.m_servers[index].host) == null) {
                this.m_host_selector_model.addElement(this.m_servers[index].host);
            }
            if (_server.name.equals(this.m_poa_model.getServerName())) {
                this.m_poa_model.setPOAs(_server.poas);
            }
        }
        catch (Exception _e) {
            this.handleException(_e);
        }
    }

    public void setServerDown(String name) {
        this.setServerDown(this.indexForServerName(name));
    }

    public void setServerDown(int server_row) {
        Registration _reg = RegistrationHelper.narrow(this.m_admin);
        try {
            _reg.set_server_down(this.m_servers[server_row].name);
        }
        catch (Exception _e) {
            this.handleException(_e);
        }
        this.refreshServer(this.m_servers[server_row].name);
    }

    public void addServer(String name, String command, String host) {
        try {
            this.m_admin.register_server(name, command, host);
        }
        catch (Exception _e) {
            this.handleException(_e);
        }
        this.fetchServers();
    }

    public JTree getTree() {
        return this.m_tree;
    }

    public void imrShutdown(boolean wait) {
        this.disableRefresh();
        try {
            this.m_admin.shutdown(wait);
            this.m_top_node.removeAllChildren();
            this.m_servers = null;
        }
        catch (Exception _e) {
            this.handleException(_e);
        }
    }

    public void saveTable() {
        try {
            this.m_admin.save_server_table();
        }
        catch (Exception _e) {
            this.handleException(_e);
        }
    }

    public int getRow(ServerInfo server, POAInfo poa) {
        for (int _i = 0; _i < server.poas.length; ++_i) {
            if (server.poas[_i] != poa) continue;
            return _i;
        }
        return -1;
    }

    public void setRefreshInterval(int interval) {
        this.m_current_refresh_interval = interval;
        this.m_refresh_disabled = false;
        this.m_refresh_thread.setInterval(interval);
    }

    public void disableRefresh() {
        this.m_refresh_disabled = true;
        this.m_refresh_thread.setInterval(0L);
    }

    protected void updateServer(int server_row, String field_name, Object new_value) {
        String _host = this.m_servers[server_row].host;
        String _cmd = this.m_servers[server_row].command;
        if (new_value instanceof String) {
            if (field_name.equals("Host")) {
                _host = (String)new_value;
                if (this.m_host_names.put(new_value, new_value) == null) {
                    this.m_host_selector_model.addElement(new_value);
                }
            } else if (field_name.equals("Command")) {
                _cmd = (String)new_value;
            }
            try {
                this.m_admin.edit_server(this.m_servers[server_row].name, _cmd, _host);
            }
            catch (Exception _e) {
                this.handleException(_e);
            }
        } else if (new_value instanceof Boolean) {
            if (field_name.equals("active")) {
                if (!((Boolean)new_value).booleanValue()) {
                    this.setServerDown(this.m_servers[server_row].name);
                }
            } else if (field_name.equals("holding")) {
                try {
                    if (((Boolean)new_value).booleanValue()) {
                        this.m_admin.hold_server(this.m_servers[server_row].name);
                    } else {
                        this.m_admin.release_server(this.m_servers[server_row].name);
                    }
                }
                catch (Exception _e) {
                    this.handleException(_e);
                }
            }
        }
        this.refreshServer(this.m_servers[server_row].name);
    }

    private void handleException(Exception e) {
        if (e instanceof UserException) {
            String _msg = e.toString();
            if (e instanceof IllegalServerName) {
                _msg = "The specified server name is not allowed";
            } else if (e instanceof DuplicateServerName) {
                _msg = "A server with name " + ((DuplicateServerName)e).name + " has already been registered with the repository";
            } else if (e instanceof FileOpFailed) {
                _msg = "The backup operation failed";
            }
            JOptionPane.showMessageDialog(new JFrame(), _msg, "An error occurred", 0);
        } else {
            this.logger.warn("Exception: ", e);
        }
    }

    private void buildHostSelectorModel() {
        int _i;
        HostInfo[] _hosts = this.m_admin.list_hosts();
        for (_i = 0; _i < _hosts.length; ++_i) {
            try {
                ServerStartupDaemon _ssd = ServerStartupDaemonHelper.narrow(this.m_orb.string_to_object(_hosts[_i].ior_string));
                _ssd.get_system_load();
                _ssd._release();
                if (this.m_host_names.put(_hosts[_i].name, _hosts[_i].name) != null) continue;
                this.m_host_selector_model.addElement(_hosts[_i].name);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (_i = 0; _i < this.m_servers.length; ++_i) {
            if (this.m_host_names.put(this.m_servers[_i].host, this.m_servers[_i].host) != null) continue;
            this.m_host_selector_model.addElement(this.m_servers[_i].host);
        }
    }

    private int indexForServerName(String name) {
        return (Integer)this.m_server_names.get(name);
    }

    private void fetchImRInfo() {
        Registration _reg = RegistrationHelper.narrow(this.m_admin);
        this.m_imr_info = _reg.get_imr_info();
    }

    private void buildServerNode(int index) {
        int _i;
        Vector<DefaultMutableTreeNode> _poas;
        DefaultMutableTreeNode _server_node;
        POAInfo[] _poa_array = this.m_servers[index].poas;
        if (index < this.m_server_nodes.size()) {
            _server_node = (DefaultMutableTreeNode)this.m_server_nodes.elementAt(index);
            _poas = (Vector<DefaultMutableTreeNode>)this.m_poa_nodes.elementAt(index);
        } else {
            _server_node = new DefaultMutableTreeNode(this.m_servers[index]);
            this.m_server_nodes.addElement(_server_node);
            this.m_tree_model.insertNodeInto(_server_node, this.m_top_node, index);
            this.m_tree.scrollPathToVisible(new TreePath(_server_node.getPath()));
            _poas = new Vector<DefaultMutableTreeNode>();
            this.m_poa_nodes.addElement(_poas);
        }
        for (_i = 0; _i < _poas.size() && _i < _poa_array.length; ++_i) {
            DefaultMutableTreeNode _poa = (DefaultMutableTreeNode)_poas.elementAt(_i);
            _poa.setUserObject(_poa_array[_i]);
        }
        if (_i >= _poa_array.length) {
            for (int _j = _poas.size() - 1; _j >= _i; --_j) {
                DefaultMutableTreeNode _poa = (DefaultMutableTreeNode)_poas.elementAt(_j);
                _poas.removeElementAt(_j);
                this.m_tree_model.removeNodeFromParent(_poa);
            }
        } else {
            for (int _j = _i; _j < _poa_array.length; ++_j) {
                DefaultMutableTreeNode _poa = new DefaultMutableTreeNode(_poa_array[_j]);
                _poas.addElement(_poa);
                this.m_tree_model.insertNodeInto(_poa, _server_node, _j);
            }
        }
    }

    private void removeServerNode(int index) {
        DefaultMutableTreeNode _server_node = (DefaultMutableTreeNode)this.m_server_nodes.elementAt(index);
        Vector _poas = (Vector)this.m_poa_nodes.elementAt(index);
        for (int _j = _poas.size() - 1; _j >= 0; --_j) {
            DefaultMutableTreeNode _poa = (DefaultMutableTreeNode)_poas.elementAt(_j);
            _poas.removeElementAt(_j);
            this.m_tree_model.removeNodeFromParent(_poa);
        }
        this.m_server_nodes.removeElementAt(index);
        this.m_tree_model.removeNodeFromParent(_server_node);
    }

    private void buildTree() {
        int _i;
        for (_i = 0; _i < this.m_server_nodes.size() && _i < this.m_servers.length; ++_i) {
            DefaultMutableTreeNode _server = (DefaultMutableTreeNode)this.m_server_nodes.elementAt(_i);
            _server.setUserObject(this.m_servers[_i]);
            this.buildServerNode(_i);
        }
        if (_i >= this.m_servers.length) {
            for (int _j = this.m_server_nodes.size() - 1; _j >= _i; --_j) {
                this.removeServerNode(_j);
            }
        } else {
            for (int _j = _i; _j < this.m_servers.length; ++_j) {
                this.buildServerNode(_j);
            }
        }
    }

    private class RefreshThread
    extends Thread {
        private long m_interval;

        public RefreshThread(long interval) {
            this.m_interval = interval;
            this.start();
        }

        @Override
        public synchronized void run() {
            while (true) {
                if (this.m_interval <= 0L) {
                    try {
                        this.wait();
                    }
                    catch (Exception _e) {
                        ImRModel.this.handleException(_e);
                    }
                    continue;
                }
                try {
                    ImRModel.this.fetchServers();
                }
                catch (Exception _e) {
                    ImRModel.this.handleException(_e);
                }
                try {
                    this.wait(this.m_interval);
                    continue;
                }
                catch (Exception _e) {
                    ImRModel.this.handleException(_e);
                    continue;
                }
                break;
            }
        }

        public synchronized void setInterval(long interval) {
            this.m_interval = interval;
            this.notifyAll();
        }
    }
}

