/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.Iterator;
import java.util.List;
import org.jacorb.orb.ProfileSelector;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.ETF.Profile;
import org.omg.RTCORBA.Protocol;

public class SpecificProfileSelector
implements ProfileSelector {
    private final Protocol[] protocols;
    private Profile currentProfile = null;

    public SpecificProfileSelector(Protocol[] protocols) {
        this.protocols = protocols;
    }

    @Override
    public Profile selectProfile(List<Profile> profiles, ClientConnectionManager ccm) {
        return this.selectNextProfile(profiles, null);
    }

    private boolean validate(Profile profile) {
        int profileTag = profile.tag();
        for (int i = 0; i < this.protocols.length; ++i) {
            int tagToMatch = this.protocols[i].protocol_type;
            if (profileTag == tagToMatch) {
                return true;
            }
            if (!(profile instanceof IIOPProfile)) continue;
            IIOPProfile iiopProfile = (IIOPProfile)profile;
            if (tagToMatch == 1245904896 && iiopProfile.getSSL() != null) {
                return true;
            }
            if (tagToMatch != 1245904897 || iiopProfile.getSSL() != null && (iiopProfile.getSSL().target_requires & 1) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Profile selectNextProfile(List<Profile> profileList, Profile lastProfile) {
        block6: {
            Profile p;
            if (profileList == null || profileList.isEmpty()) {
                return null;
            }
            Iterator<Profile> iterator = profileList.iterator();
            while (iterator.hasNext()) {
                p = iterator.next();
                if (lastProfile != null) {
                    if (!lastProfile.equals(p)) continue;
                    break;
                }
                if (!this.validate(p)) continue;
                this.currentProfile = p;
                return p;
            }
            if (lastProfile == null) {
                this.currentProfile = null;
                return null;
            }
            do {
                if (!iterator.hasNext()) {
                    iterator = profileList.iterator();
                }
                if (lastProfile.equals(p = iterator.next())) break block6;
            } while (!this.validate(p));
            this.currentProfile = p;
            return p;
        }
        return null;
    }
}

