/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;

public class SwingThreadDispatcher {
    private static boolean DEBUG_NORMAL = false;
    private static boolean DEBUG_BUG = false;
    private static PrintStream[] printStreamList = null;
    private static ExecutorService executor;

    public static void invokeLater(Runnable doRun) {
        if (AppContext.getAppContext() != null) {
            SwingThreadDispatcher.showDefault("SwingThreadDispatcher.invokeLater", "AppContext nao e' null portanto delega para SwingUtilities.invokeLater");
            SwingUtilities.invokeLater(doRun);
            return;
        }
        SwingThreadDispatcher.show("SwingThreadDispatcher.invokeLater", "AppContext e' null portanto usa uma FutureTask para executar");
        FutureTask<Void> task = new FutureTask<Void>(new InvokeLaterCallable(doRun));
        executor.submit(task);
    }

    public static boolean isEventDispatchThread() {
        if (AppContext.getAppContext() != null) {
            boolean result = SwingUtilities.isEventDispatchThread();
            SwingThreadDispatcher.showDefault("SwingThreadDispatcher.isEventDispatchThread", "AppContext nao e' null portanto delega para SwingUtilities.isEventDispatchThread: " + result);
            return result;
        }
        SwingThreadDispatcher.show("SwingThreadDispatcher.isEventDispatchThread", "AppContext e' null portanto retorna false.");
        return false;
    }

    public static void invokeAndWait(Runnable doRun) throws InterruptedException, InvocationTargetException {
        if (AppContext.getAppContext() != null) {
            SwingThreadDispatcher.showDefault("SwingThreadDispatcher.invokeAndWait", "AppContext nao e' null portanto delega para SwingUtilities.invokeAndWait.");
            SwingUtilities.invokeAndWait(doRun);
            return;
        }
        SwingThreadDispatcher.show("SwingThreadDispatcher.invokeAndWait", "AppContext e' null portanto usa uma FutureTask para aguardar");
        FutureTask<Void> task = new FutureTask<Void>(new InvokeAndWaitCallable(doRun));
        executor.submit(task);
        try {
            task.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause.getClass().equals(InvocationTargetException.class)) {
                SwingThreadDispatcher.show("SwingThreadDispatcher.invokeAndWait", "Exce\u00e7\u00e3o InvocationTargetException.");
                throw (InvocationTargetException)InvocationTargetException.class.cast(cause);
            }
            if (cause.getClass().equals(InterruptedException.class)) {
                SwingThreadDispatcher.show("SwingThreadDispatcher.invokeAndWait", "Exce\u00e7\u00e3o InterruptedException.");
                throw (InterruptedException)InterruptedException.class.cast(cause);
            }
            throw new RuntimeException("Ocorreu um erro na tentativa de usar o executor.", e);
        }
    }

    public static void init() {
        if (AppContext.getAppContext() == null) {
            SwingThreadDispatcher.show("SwingThreadDispatcher.init", "AppContext e' null e o init nao pode ser chamado.");
            throw new RuntimeException("O init nao pode ser chamado com appContext null");
        }
        if (executor != null) {
            SwingThreadDispatcher.show("SwingThreadDispatcher.init", "AppContext nao e' null mas o init ja' foi chamado.");
            return;
        }
        SwingThreadDispatcher.show("SwingThreadDispatcher.init", "AppContext nao e' null. Cria e inicia o executor de processamento.");
        executor = Executors.newSingleThreadExecutor();
        Future<Boolean> future = executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return AppContext.getAppContext() == null;
            }
        });
        try {
            if (future.get().booleanValue()) {
                throw new RuntimeException("O executor est\u00e1 com appContext null.");
            }
            SwingThreadDispatcher.show("SwingThreadDispatcher.init", "O executor foi criado corretamente com AppContext nao null.");
        }
        catch (Exception e) {
            throw new RuntimeException("Ocorreu um erro na tentativa de usar o executor.", e);
        }
    }

    private static void show(String methodName, String msg) {
        if (DEBUG_BUG) {
            if (printStreamList == null) {
                printStreamList = new PrintStream[]{System.out};
            }
            for (PrintStream o : printStreamList) {
                o.println(">> " + methodName + ": " + msg);
            }
        }
    }

    private static void showDefault(String methodName, String msg) {
        if (DEBUG_NORMAL) {
            if (printStreamList == null) {
                printStreamList = new PrintStream[]{System.out};
            }
            for (PrintStream o : printStreamList) {
                o.println(methodName + ": " + msg);
            }
        }
    }

    public static void setPrinter(PrintStream ... outputStreamList) {
        printStreamList = outputStreamList;
    }

    public static void setDebugMode(boolean error, boolean success) {
        DEBUG_BUG = error;
        DEBUG_NORMAL = success;
    }

    private static class InvokeAndWaitCallable
    implements Callable<Void> {
        private Runnable doRun;

        public InvokeAndWaitCallable(Runnable doRun) {
            this.doRun = doRun;
        }

        @Override
        public Void call() throws Exception {
            SwingThreadDispatcher.show("InvokeAndWaitCallable.call", "Chamando o SwingUtilities.invokeAndWait");
            SwingUtilities.invokeAndWait(this.doRun);
            SwingThreadDispatcher.show("InvokeAndWaitCallable.call", "SwingUtilities.invokeAndWait executado com sucesso");
            return null;
        }
    }

    private static class InvokeLaterCallable
    implements Callable<Void> {
        private Runnable doRun;

        public InvokeLaterCallable(Runnable doRun) {
            this.doRun = doRun;
        }

        @Override
        public Void call() throws Exception {
            SwingThreadDispatcher.show("InvokeLaterCallable.call", "Chamando o SwingUtilities.invokeLater");
            SwingUtilities.invokeLater(this.doRun);
            SwingThreadDispatcher.show("InvokeLaterCallable.call", "SwingUtilities.invokeLater executado com sucesso");
            return null;
        }
    }
}

